/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.analytics.action;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.stats.EnumCounters;

public class AnalyticsStatsAction
extends ActionType<Response> {
    public static final AnalyticsStatsAction INSTANCE = new AnalyticsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/analytics/stats";

    private AnalyticsStatsAction() {
        super(NAME, Response::new);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final EnumCounters<Item> counters;

        public NodeResponse(DiscoveryNode node, EnumCounters<Item> counters) {
            super(node);
            this.counters = counters;
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_8_0)) {
                this.counters = new EnumCounters<Item>(in, Item.class);
            } else {
                this.counters = new EnumCounters<Item>(Item.class);
                if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_7_0)) {
                    this.counters.inc(Item.BOXPLOT, in.readVLong());
                }
                this.counters.inc(Item.CUMULATIVE_CARDINALITY, in.readZLong());
                if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_7_0)) {
                    this.counters.inc(Item.STRING_STATS, in.readVLong());
                    this.counters.inc(Item.TOP_METRICS, in.readVLong());
                }
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_8_0)) {
                this.counters.writeTo(out);
            } else {
                if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_7_0)) {
                    out.writeVLong(this.counters.get(Item.BOXPLOT));
                }
                out.writeZLong(this.counters.get(Item.CUMULATIVE_CARDINALITY));
                if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_7_0)) {
                    out.writeVLong(this.counters.get(Item.STRING_STATS));
                    out.writeVLong(this.counters.get(Item.TOP_METRICS));
                }
            }
        }

        public EnumCounters<Item> getStats() {
            return this.counters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)((Object)o);
            return this.counters.equals(that.counters) && this.getNode().equals((Object)that.getNode());
        }

        public int hashCode() {
            return Objects.hash(this.counters, this.getNode());
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }

        public EnumCounters<Item> getStats() {
            List countersPerNode = this.getNodes().stream().map(NodeResponse::getStats).collect(Collectors.toList());
            return EnumCounters.merge(Item.class, countersPerNode);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            EnumCounters<Item> stats = this.getStats();
            builder.startObject("stats");
            for (Item item : Item.values()) {
                builder.field(item.name().toLowerCase(Locale.ROOT) + "_usage", stats.get(item));
            }
            builder.endObject();
            return builder;
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest(Request request) {
        }
    }

    public static class Request
    extends BaseNodesRequest<Request>
    implements ToXContentObject {
        public Request() {
            super((String[])null);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(AnalyticsStatsAction.NAME);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }
    }

    public static enum Item {
        BOXPLOT,
        CUMULATIVE_CARDINALITY,
        STRING_STATS,
        TOP_METRICS,
        T_TEST,
        MOVING_PERCENTILES,
        NORMALIZE,
        RATE,
        MULTI_TERMS;

    }
}

