/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.routing.allocation;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;

public final class DataTierAllocationDecider
extends AllocationDecider {
    public static final String NAME = "data_tier";
    public static final DataTierAllocationDecider INSTANCE = new DataTierAllocationDecider();
    private static final Decision YES_PASSES = Decision.single((Decision.Type)Decision.YES.type(), (String)"data_tier", (String)"node passes tier preference filters", (Object[])new Object[0]);

    private DataTierAllocationDecider() {
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return DataTierAllocationDecider.shouldFilter(allocation.metadata().getIndexSafe(shardRouting.index()), node.node(), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return DataTierAllocationDecider.shouldFilter(indexMetadata, node.node(), allocation);
    }

    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return DataTierAllocationDecider.shouldFilter(indexMetadata, node.node(), allocation);
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return DataTierAllocationDecider.shouldFilter(indexMetadata, node, allocation);
    }

    private static Decision shouldFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        return DataTierAllocationDecider.shouldFilter(indexMd, node, DataTierAllocationDecider::preferredAvailableTier, allocation);
    }

    public static Decision shouldFilter(IndexMetadata indexMd, DiscoveryNode node, PreferredTierFunction preferredTierFunction, RoutingAllocation allocation) {
        List tierPreference = indexMd.getTierPreference();
        if (tierPreference.isEmpty()) {
            return YES_PASSES;
        }
        Optional<String> tier = preferredTierFunction.apply(tierPreference, allocation.nodes(), allocation.desiredNodes());
        if (tier.isPresent()) {
            String tierName = tier.get();
            if (DataTierAllocationDecider.allocationAllowed(tierName, node)) {
                if (allocation.debugDecision()) {
                    return DataTierAllocationDecider.debugYesAllowed(allocation, tierPreference, tierName);
                }
                return Decision.YES;
            }
            if (allocation.debugDecision()) {
                return DataTierAllocationDecider.debugNoRequirementsNotMet(allocation, tierPreference, tierName);
            }
            return Decision.NO;
        }
        if (allocation.debugDecision()) {
            return DataTierAllocationDecider.debugNoNoNodesAvailable(allocation, tierPreference);
        }
        return Decision.NO;
    }

    private static Decision debugNoNoNodesAvailable(RoutingAllocation allocation, List<String> tierPreference) {
        return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s], but no nodes for any of those tiers are available in the cluster", new Object[]{String.join((CharSequence)",", tierPreference)});
    }

    private static Decision debugNoRequirementsNotMet(RoutingAllocation allocation, List<String> tierPreference, String tierName) {
        return allocation.decision(Decision.NO, NAME, "index has a preference for tiers [%s] and node does not meet the required [%s] tier", new Object[]{String.join((CharSequence)",", tierPreference), tierName});
    }

    private static Decision debugYesAllowed(RoutingAllocation allocation, List<String> tierPreference, String tierName) {
        return allocation.decision(Decision.YES, NAME, "index has a preference for tiers [%s] and node has tier [%s]", new Object[]{String.join((CharSequence)",", tierPreference), tierName});
    }

    public static Optional<String> preferredAvailableTier(List<String> prioritizedTiers, DiscoveryNodes nodes, DesiredNodes desiredNodes) {
        Optional<String> desiredNodesPreferredTier = DataTierAllocationDecider.getPreferredTierFromDesiredNodes(prioritizedTiers, nodes, desiredNodes);
        if (desiredNodesPreferredTier.isPresent()) {
            return desiredNodesPreferredTier;
        }
        return DataTierAllocationDecider.getPreferredAvailableTierFromClusterMembers(prioritizedTiers, nodes);
    }

    public static Optional<String> getPreferredTierFromDesiredNodes(List<String> prioritizedTiers, DiscoveryNodes discoveryNodes, DesiredNodes desiredNodes) {
        if (desiredNodes == null) {
            return Optional.empty();
        }
        for (int tierIndex = 0; tierIndex < prioritizedTiers.size(); ++tierIndex) {
            String tier = prioritizedTiers.get(tierIndex);
            if (!DataTierAllocationDecider.tierNodesPresent(tier, desiredNodes.actualized()) && !DataTierAllocationDecider.isDesiredNodeWithinTierJoining(tier, discoveryNodes, desiredNodes) && !DataTierAllocationDecider.nextTierIsGrowingAndCurrentTierCanHoldTheIndex(prioritizedTiers, tierIndex, discoveryNodes, desiredNodes)) continue;
            return Optional.of(tier);
        }
        return Optional.empty();
    }

    private static boolean nextTierIsGrowingAndCurrentTierCanHoldTheIndex(List<String> prioritizedTiers, int tierIndex, DiscoveryNodes discoveryNodes, DesiredNodes desiredNodes) {
        String tier = prioritizedTiers.get(tierIndex);
        assert (!DataTierAllocationDecider.tierNodesPresent(tier, desiredNodes.actualized()));
        boolean nextPreferredTierIsGrowing = false;
        for (int i = tierIndex + 1; i < prioritizedTiers.size(); ++i) {
            String nextTier = prioritizedTiers.get(i);
            nextPreferredTierIsGrowing |= DataTierAllocationDecider.tierNodesPresent(nextTier, desiredNodes.pending());
        }
        return DataTierAllocationDecider.tierNodesPresent(tier, discoveryNodes) && nextPreferredTierIsGrowing;
    }

    private static boolean isDesiredNodeWithinTierJoining(String tier, DiscoveryNodes discoveryNodes, DesiredNodes desiredNodes) {
        assert (!DataTierAllocationDecider.tierNodesPresent(tier, desiredNodes.actualized()));
        return DataTierAllocationDecider.tierNodesPresent(tier, desiredNodes.pending()) && DataTierAllocationDecider.tierNodesPresent(tier, discoveryNodes);
    }

    private static Optional<String> getPreferredAvailableTierFromClusterMembers(List<String> prioritizedTiers, DiscoveryNodes nodes) {
        for (String tier : prioritizedTiers) {
            if (!DataTierAllocationDecider.tierNodesPresent(tier, nodes)) continue;
            return Optional.of(tier);
        }
        return Optional.empty();
    }

    static boolean tierNodesPresent(String singleTier, Collection<DesiredNode> nodes) {
        assert (singleTier.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) || DataTier.validTierName((String)singleTier)) : "tier " + singleTier + " is an invalid tier name";
        for (DesiredNode node : nodes) {
            if (!DataTierAllocationDecider.allocationAllowed(singleTier, node.getRoles())) continue;
            return true;
        }
        return false;
    }

    static boolean tierNodesPresent(String singleTier, DiscoveryNodes nodes) {
        assert (singleTier.equals(DiscoveryNodeRole.DATA_ROLE.roleName()) || DataTier.validTierName((String)singleTier)) : "tier " + singleTier + " is an invalid tier name";
        return nodes.isRoleAvailable(DiscoveryNodeRole.DATA_ROLE.roleName()) || nodes.isRoleAvailable(singleTier);
    }

    public static boolean allocationAllowed(String tierName, DiscoveryNode node) {
        assert (Strings.hasText((String)tierName)) : "tierName must be not null and non-empty, but was [" + tierName + "]";
        return node.hasRole(DiscoveryNodeRole.DATA_ROLE.roleName()) || node.hasRole(tierName);
    }

    public static boolean allocationAllowed(String tierName, Set<DiscoveryNodeRole> roles) {
        assert (Strings.hasText((String)tierName)) : "tierName must be not null and non-empty, but was [" + tierName + "]";
        if (roles.contains(DiscoveryNodeRole.DATA_ROLE)) {
            return true;
        }
        for (DiscoveryNodeRole role : roles) {
            if (!tierName.equals(role.roleName())) continue;
            return true;
        }
        return false;
    }

    public static interface PreferredTierFunction {
        public Optional<String> apply(List<String> var1, DiscoveryNodes var2, DesiredNodes var3);
    }
}

