/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.idp;

import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.impl.ContactPersonBuilder;
import org.opensaml.saml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.GivenNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.IDPSSODescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.NameIDFormatBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationDisplayNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationNameBuilder;
import org.opensaml.saml.saml2.metadata.impl.OrganizationURLBuilder;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.SingleSignOnServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.SurNameBuilder;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;

public class SamlIdPMetadataBuilder {
    private Locale locale;
    private final String entityId;
    private Set<String> nameIdFormats;
    private boolean wantAuthnRequestsSigned;
    private Map<String, URL> singleSignOnServiceUrls = new HashMap<String, URL>();
    private Map<String, URL> singleLogoutServiceUrls = new HashMap<String, URL>();
    private List<X509Certificate> signingCertificates;
    private SamlIdentityProvider.OrganizationInfo organization;
    private final List<SamlIdentityProvider.ContactInfo> contacts;

    public SamlIdPMetadataBuilder(String entityId) {
        this.entityId = entityId;
        this.locale = Locale.getDefault();
        this.contacts = new ArrayList<SamlIdentityProvider.ContactInfo>();
        this.nameIdFormats = new HashSet<String>();
        this.signingCertificates = new ArrayList<X509Certificate>();
        this.wantAuthnRequestsSigned = false;
    }

    public SamlIdPMetadataBuilder withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public SamlIdPMetadataBuilder withNameIdFormat(String nameIdFormat) {
        if (!Strings.isNullOrEmpty((String)nameIdFormat)) {
            this.nameIdFormats.add(nameIdFormat);
        }
        return this;
    }

    public SamlIdPMetadataBuilder wantAuthnRequestsSigned(boolean wants) {
        this.wantAuthnRequestsSigned = wants;
        return this;
    }

    public SamlIdPMetadataBuilder withSingleSignOnServiceUrl(String binding, URL url) {
        if (null != url) {
            this.singleSignOnServiceUrls.put(binding, url);
        }
        return this;
    }

    public SamlIdPMetadataBuilder withSingleLogoutServiceUrl(String binding, URL url) {
        if (null != url) {
            this.singleLogoutServiceUrls.put(binding, url);
        }
        return this;
    }

    public SamlIdPMetadataBuilder withSigningCertificates(List<X509Certificate> signingCertificates) {
        if (null != signingCertificates) {
            this.signingCertificates.addAll(signingCertificates);
        }
        return this;
    }

    public SamlIdPMetadataBuilder withSigningCertificate(X509Certificate signingCertificate) {
        if (null != signingCertificate) {
            return this.withSigningCertificates(Collections.singletonList(signingCertificate));
        }
        return this;
    }

    public SamlIdPMetadataBuilder organization(SamlIdentityProvider.OrganizationInfo organization) {
        if (null != organization) {
            this.organization = organization;
        }
        return this;
    }

    public SamlIdPMetadataBuilder organization(String orgName, String displayName, String url) {
        return this.organization(new SamlIdentityProvider.OrganizationInfo(orgName, displayName, url));
    }

    public SamlIdPMetadataBuilder withContact(SamlIdentityProvider.ContactInfo contact) {
        if (null != contact) {
            this.contacts.add(contact);
        }
        return this;
    }

    public SamlIdPMetadataBuilder withContact(String type, String givenName, String surName, String email) {
        return this.withContact(new SamlIdentityProvider.ContactInfo(SamlIdentityProvider.ContactInfo.getType(type), givenName, surName, email));
    }

    public EntityDescriptor build() throws CertificateEncodingException {
        IDPSSODescriptor idpSsoDescriptor = new IDPSSODescriptorBuilder().buildObject();
        idpSsoDescriptor.removeAllSupportedProtocols();
        idpSsoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        idpSsoDescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(this.wantAuthnRequestsSigned));
        if (!this.nameIdFormats.isEmpty()) {
            idpSsoDescriptor.getNameIDFormats().addAll(this.buildNameIDFormats());
        }
        if (!this.singleSignOnServiceUrls.isEmpty()) {
            idpSsoDescriptor.getSingleSignOnServices().addAll(this.buildSingleSignOnServices());
        }
        if (!this.singleLogoutServiceUrls.isEmpty()) {
            idpSsoDescriptor.getSingleLogoutServices().addAll(this.buildSingleLogoutServices());
        }
        idpSsoDescriptor.getKeyDescriptors().addAll(this.buildKeyDescriptors());
        EntityDescriptor descriptor = new EntityDescriptorBuilder().buildObject();
        descriptor.setEntityID(this.entityId);
        descriptor.getRoleDescriptors().add(idpSsoDescriptor);
        if (this.organization != null) {
            descriptor.setOrganization(this.buildOrganization());
        }
        for (SamlIdentityProvider.ContactInfo contact : this.contacts) {
            descriptor.getContactPersons().add(this.buildContact(contact));
        }
        return descriptor;
    }

    private List<SingleSignOnService> buildSingleSignOnServices() {
        ArrayList<SingleSignOnService> ssoServices = new ArrayList<SingleSignOnService>();
        if (this.singleSignOnServiceUrls.isEmpty()) {
            throw new IllegalStateException("At least one SingleSignOnService URL should be specified");
        }
        for (Map.Entry<String, URL> entry : this.singleSignOnServiceUrls.entrySet()) {
            SingleSignOnService sso = new SingleSignOnServiceBuilder().buildObject();
            sso.setBinding(entry.getKey());
            sso.setLocation(entry.getValue().toString());
            ssoServices.add(sso);
        }
        return ssoServices;
    }

    private List<SingleLogoutService> buildSingleLogoutServices() {
        ArrayList<SingleLogoutService> sloServices = new ArrayList<SingleLogoutService>();
        for (Map.Entry<String, URL> entry : this.singleLogoutServiceUrls.entrySet()) {
            SingleLogoutService slo = new SingleLogoutServiceBuilder().buildObject();
            slo.setBinding(entry.getKey());
            slo.setLocation(entry.getValue().toString());
            sloServices.add(slo);
        }
        return sloServices;
    }

    private List<NameIDFormat> buildNameIDFormats() {
        ArrayList<NameIDFormat> formats = new ArrayList<NameIDFormat>();
        if (this.nameIdFormats.isEmpty()) {
            throw new IllegalStateException("NameID format has not been specified");
        }
        for (String nameIdFormat : this.nameIdFormats) {
            NameIDFormat format = new NameIDFormatBuilder().buildObject();
            format.setURI(nameIdFormat);
            formats.add(format);
        }
        return formats;
    }

    private List<? extends KeyDescriptor> buildKeyDescriptors() throws CertificateEncodingException {
        if (this.signingCertificates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyDescriptor> keys = new ArrayList<KeyDescriptor>();
        for (X509Certificate signingCertificate : this.signingCertificates) {
            if (signingCertificate == null) continue;
            KeyDescriptor descriptor = new KeyDescriptorBuilder().buildObject();
            descriptor.setUse(UsageType.SIGNING);
            KeyInfo keyInfo = new KeyInfoBuilder().buildObject();
            KeyInfoSupport.addCertificate((KeyInfo)keyInfo, (X509Certificate)signingCertificate);
            descriptor.setKeyInfo(keyInfo);
            keys.add(descriptor);
        }
        return keys;
    }

    private Organization buildOrganization() {
        String lang = this.locale.toLanguageTag();
        OrganizationName name = new OrganizationNameBuilder().buildObject();
        name.setValue(this.organization.organizationName);
        name.setXMLLang(lang);
        OrganizationDisplayName displayName = new OrganizationDisplayNameBuilder().buildObject();
        displayName.setValue(this.organization.displayName);
        displayName.setXMLLang(lang);
        OrganizationURL url = new OrganizationURLBuilder().buildObject();
        url.setURI(this.organization.url);
        url.setXMLLang(lang);
        Organization org = new OrganizationBuilder().buildObject();
        org.getOrganizationNames().add(name);
        org.getDisplayNames().add(displayName);
        org.getURLs().add(url);
        return org;
    }

    private ContactPerson buildContact(SamlIdentityProvider.ContactInfo contact) {
        GivenName givenName = new GivenNameBuilder().buildObject();
        givenName.setValue(contact.givenName);
        SurName surName = new SurNameBuilder().buildObject();
        surName.setValue(contact.surName);
        EmailAddress email = new EmailAddressBuilder().buildObject();
        email.setURI(contact.email);
        ContactPerson person = new ContactPersonBuilder().buildObject();
        person.setType(contact.type);
        person.setGivenName(givenName);
        person.setSurName(surName);
        person.getEmailAddresses().add(email);
        return person;
    }
}

