/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.privileges;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.idp.privileges.ApplicationActionsResolver;
import org.elasticsearch.xpack.idp.privileges.ServiceProviderPrivileges;

public class UserPrivilegeResolver {
    private final Logger logger = LogManager.getLogger(UserPrivilegeResolver.class);
    private final Client client;
    private final SecurityContext securityContext;
    private final ApplicationActionsResolver actionsResolver;

    public UserPrivilegeResolver(Client client, SecurityContext securityContext, ApplicationActionsResolver actionsResolver) {
        this.client = client;
        this.securityContext = securityContext;
        this.actionsResolver = actionsResolver;
    }

    public void resolve(ServiceProviderPrivileges service, ActionListener<UserPrivileges> listener) {
        this.buildResourcePrivilege(service, (ActionListener<RoleDescriptor.ApplicationResourcePrivileges>)ActionListener.wrap(resourcePrivilege -> {
            String username = this.securityContext.requireUser().principal();
            if (resourcePrivilege == null) {
                listener.onResponse((Object)UserPrivileges.noAccess(username));
                return;
            }
            HasPrivilegesRequest request = new HasPrivilegesRequest();
            request.username(username);
            request.clusterPrivileges(Strings.EMPTY_ARRAY);
            request.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
            request.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[]{resourcePrivilege});
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
                this.logger.debug("Checking access for user [{}] to application [{}] resource [{}]", (Object)username, (Object)service.getApplicationName(), (Object)service.getResource());
                UserPrivileges privileges = this.buildResult((HasPrivilegesResponse)response, service);
                this.logger.debug("Resolved service privileges [{}]", (Object)privileges);
                listener.onResponse((Object)privileges);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private UserPrivileges buildResult(HasPrivilegesResponse response, ServiceProviderPrivileges service) {
        Set appPrivileges = (Set)response.getApplicationPrivileges().get(service.getApplicationName());
        if (appPrivileges == null || appPrivileges.isEmpty()) {
            return UserPrivileges.noAccess(response.getUsername());
        }
        Set<String> roles = appPrivileges.stream().filter(rp -> rp.getResource().equals(service.getResource())).map(rp -> rp.getPrivileges().entrySet()).flatMap(Collection::stream).filter(Map.Entry::getValue).map(Map.Entry::getKey).map(service.getRoleMapping()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        boolean hasAccess = !roles.isEmpty();
        return new UserPrivileges(response.getUsername(), hasAccess, roles);
    }

    private void buildResourcePrivilege(ServiceProviderPrivileges service, ActionListener<RoleDescriptor.ApplicationResourcePrivileges> listener) {
        this.actionsResolver.getActions(service.getApplicationName(), (ActionListener<Set<String>>)ActionListener.wrap(actions -> {
            if (actions == null || actions.isEmpty()) {
                this.logger.warn("No application-privilege actions defined for application [{}]", (Object)service.getApplicationName());
                listener.onResponse(null);
            } else {
                this.logger.debug("Using actions [{}] for application [{}]", actions, (Object)service.getApplicationName());
                RoleDescriptor.ApplicationResourcePrivileges.Builder builder = RoleDescriptor.ApplicationResourcePrivileges.builder();
                builder.application(service.getApplicationName());
                builder.resources(new String[]{service.getResource()});
                builder.privileges((Collection)actions);
                listener.onResponse((Object)builder.build());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public static class UserPrivileges {
        public final String principal;
        public final boolean hasAccess;
        public final Set<String> roles;

        public UserPrivileges(String principal, boolean hasAccess, Set<String> roles) {
            this.principal = Objects.requireNonNull(principal, "principal may not be null");
            if (!hasAccess && !roles.isEmpty()) {
                throw new IllegalArgumentException("a user without access may not have roles ([" + roles + "])");
            }
            this.hasAccess = hasAccess;
            this.roles = Set.copyOf((Collection)Objects.requireNonNull(roles, "roles may not be null"));
        }

        public String toString() {
            StringBuilder str = new StringBuilder().append(this.getClass().getSimpleName()).append("{").append(this.principal).append(", ").append(this.hasAccess);
            if (this.hasAccess) {
                str.append(", ").append(this.roles);
            }
            str.append("}");
            return str.toString();
        }

        public static UserPrivileges noAccess(String principal) {
            return new UserPrivileges(principal, false, Set.of());
        }
    }
}

