/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import java.util.LinkedHashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xpack.eql.analysis.Analyzer;
import org.elasticsearch.xpack.eql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.eql.analysis.PostAnalyzer;
import org.elasticsearch.xpack.eql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.eql.analysis.Verifier;
import org.elasticsearch.xpack.eql.optimizer.Optimizer;
import org.elasticsearch.xpack.eql.parser.EqlParser;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.planner.Planner;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.Results;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.util.ActionListeners;

public class EqlSession {
    private final Client client;
    private final EqlConfiguration configuration;
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final PostAnalyzer postAnalyzer;
    private final Analyzer analyzer;
    private final Optimizer optimizer;
    private final Planner planner;
    private final CircuitBreaker circuitBreaker;

    public EqlSession(Client client, EqlConfiguration cfg, IndexResolver indexResolver, PreAnalyzer preAnalyzer, PostAnalyzer postAnalyzer, FunctionRegistry functionRegistry, Verifier verifier, Optimizer optimizer, Planner planner, CircuitBreaker circuitBreaker) {
        this.client = new ParentTaskAssigningClient(client, cfg.getTaskId());
        this.configuration = cfg;
        this.indexResolver = indexResolver;
        this.preAnalyzer = preAnalyzer;
        this.postAnalyzer = postAnalyzer;
        this.analyzer = new Analyzer(new AnalyzerContext(cfg, functionRegistry), verifier);
        this.optimizer = optimizer;
        this.planner = planner;
        this.circuitBreaker = circuitBreaker;
    }

    public Client client() {
        return this.client;
    }

    public Optimizer optimizer() {
        return this.optimizer;
    }

    public EqlConfiguration configuration() {
        return this.configuration;
    }

    public CircuitBreaker circuitBreaker() {
        return this.circuitBreaker;
    }

    public void eql(String eql, ParserParams params, ActionListener<Results> listener) {
        this.eqlExecutable(eql, params, (ActionListener<PhysicalPlan>)ActionListener.wrap(e -> e.execute(this, ActionListeners.map((ActionListener)listener, Results::fromPayload)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void eqlExecutable(String eql, ParserParams params, ActionListener<PhysicalPlan> listener) {
        try {
            this.physicalPlan(this.doParse(eql, params), listener);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public void physicalPlan(LogicalPlan optimized, ActionListener<PhysicalPlan> listener) {
        this.optimizedPlan(optimized, (ActionListener<LogicalPlan>)ActionListeners.map(listener, this.planner::plan));
    }

    public void optimizedPlan(LogicalPlan verified, ActionListener<LogicalPlan> listener) {
        this.analyzedPlan(verified, (ActionListener<LogicalPlan>)ActionListeners.map(listener, this.optimizer::optimize));
    }

    public void analyzedPlan(LogicalPlan parsed, ActionListener<LogicalPlan> listener) {
        if (parsed.analyzed()) {
            listener.onResponse((Object)parsed);
            return;
        }
        this.preAnalyze(parsed, (ActionListener<LogicalPlan>)ActionListeners.map(listener, p -> this.postAnalyze(this.analyzer.analyze((LogicalPlan)p))));
    }

    private <T> void preAnalyze(LogicalPlan parsed, ActionListener<LogicalPlan> listener) {
        String indexWildcard = this.configuration.indexAsWildcard();
        if (this.configuration.isCancelled()) {
            listener.onFailure((Exception)new TaskCancelledException("cancelled"));
            return;
        }
        Set<String> fieldNames = EqlSession.fieldNames(parsed);
        this.indexResolver.resolveAsMergedMapping(indexWildcard, fieldNames, this.configuration.indicesOptions(), this.configuration.runtimeMappings(), ActionListeners.map(listener, r -> this.preAnalyzer.preAnalyze(parsed, (IndexResolution)r)));
    }

    static Set<String> fieldNames(LogicalPlan parsed) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        parsed.forEachExpressionDown(UnresolvedAttribute.class, ua -> {
            fieldNames.add(ua.name());
            if (!ua.name().endsWith("*")) {
                fieldNames.add(ua.name() + ".*");
            }
        });
        return fieldNames.isEmpty() ? IndexResolver.ALL_FIELDS : fieldNames;
    }

    private LogicalPlan postAnalyze(LogicalPlan verified) {
        return this.postAnalyzer.postAnalyze(verified, this.configuration);
    }

    private LogicalPlan doParse(String eql, ParserParams params) {
        return new EqlParser().createStatement(eql, params);
    }
}

