/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.BetweenFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.BetweenFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseInsensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Between
extends CaseInsensitiveScalarFunction
implements OptionalArgument {
    private final Expression input;
    private final Expression left;
    private final Expression right;
    private final Expression greedy;

    public Between(Source source, Expression input, Expression left, Expression right, Expression greedy, boolean caseInsensitive) {
        super(source, Arrays.asList(input, left, right, Between.defaultGreedy(greedy)), caseInsensitive);
        this.input = input;
        this.left = left;
        this.right = right;
        this.greedy = (Expression)this.arguments().get(3);
    }

    private static Expression defaultGreedy(Expression exp) {
        return exp != null ? exp : Literal.FALSE;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isStringAndExact((Expression)this.left, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isStringAndExact((Expression)this.right, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isBoolean((Expression)this.greedy, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FOURTH);
    }

    public Expression input() {
        return this.input;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression greedy() {
        return this.greedy;
    }

    protected Pipe makePipe() {
        return new BetweenFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.left), Expressions.pipe((Expression)this.right), Expressions.pipe((Expression)this.greedy), this.isCaseInsensitive());
    }

    public boolean foldable() {
        return this.input.foldable() && this.left.foldable() && this.right.foldable() && this.greedy.foldable();
    }

    public Object fold() {
        return BetweenFunctionProcessor.doProcess(this.input.fold(), this.left.fold(), this.right.fold(), this.greedy.fold(), this.isCaseInsensitive());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Between::new, (Object)this.input, (Object)this.left, (Object)this.right, (Object)this.greedy, (Object)this.isCaseInsensitive());
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate leftScript = this.asScript(this.left);
        ScriptTemplate rightScript = this.asScript(this.right);
        ScriptTemplate greedyScript = this.asScript(this.greedy);
        return this.asScriptFrom(inputScript, leftScript, rightScript, greedyScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate leftScript, ScriptTemplate rightScript, ScriptTemplate greedyScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s,%s,%s,%s,%s)"), "between", inputScript.template(), leftScript.template(), rightScript.template(), greedyScript.template(), "{}"), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(leftScript.params()).script(rightScript.params()).script(greedyScript.params()).variable((Object)this.isCaseInsensitive()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Between(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3), this.isCaseInsensitive());
    }
}

