/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.repositories.metering.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.repositories.metering.action.ClearRepositoriesMeteringArchiveRequest;
import org.elasticsearch.xpack.repositories.metering.action.RepositoriesMeteringResponse;
import org.elasticsearch.xpack.repositories.metering.action.RepositoriesNodeMeteringResponse;

public final class TransportClearRepositoriesStatsArchiveAction
extends TransportNodesAction<ClearRepositoriesMeteringArchiveRequest, RepositoriesMeteringResponse, ClearRepositoriesStatsArchiveNodeRequest, RepositoriesNodeMeteringResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportClearRepositoriesStatsArchiveAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, RepositoriesService repositoriesService) {
        super("cluster:monitor/xpack/repositories_metering/clear_metering_archive", threadPool, clusterService, transportService, actionFilters, ClearRepositoriesMeteringArchiveRequest::new, ClearRepositoriesStatsArchiveNodeRequest::new, "generic");
        this.repositoriesService = repositoriesService;
    }

    protected RepositoriesMeteringResponse newResponse(ClearRepositoriesMeteringArchiveRequest request, List<RepositoriesNodeMeteringResponse> nodesResponses, List<FailedNodeException> failures) {
        return new RepositoriesMeteringResponse(this.clusterService.getClusterName(), nodesResponses, failures);
    }

    protected ClearRepositoriesStatsArchiveNodeRequest newNodeRequest(ClearRepositoriesMeteringArchiveRequest request) {
        return new ClearRepositoriesStatsArchiveNodeRequest(request.getMaxVersionToClear());
    }

    protected RepositoriesNodeMeteringResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new RepositoriesNodeMeteringResponse(in);
    }

    protected RepositoriesNodeMeteringResponse nodeOperation(ClearRepositoriesStatsArchiveNodeRequest request, Task task) {
        List clearedStats = this.repositoriesService.clearRepositoriesStatsArchive(request.maxVersionToClear);
        return new RepositoriesNodeMeteringResponse(this.clusterService.localNode(), clearedStats);
    }

    static final class ClearRepositoriesStatsArchiveNodeRequest
    extends TransportRequest {
        private final long maxVersionToClear;

        ClearRepositoriesStatsArchiveNodeRequest(long maxVersionToClear) {
            this.maxVersionToClear = maxVersionToClear;
        }

        ClearRepositoriesStatsArchiveNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.maxVersionToClear = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.maxVersionToClear);
        }
    }
}

