/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.metric;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.set.Sets;

public class RunningStats
implements Writeable,
Cloneable {
    protected long docCount = 0L;
    protected HashMap<String, Double> fieldSum;
    protected HashMap<String, Long> counts;
    protected HashMap<String, Double> means;
    protected HashMap<String, Double> variances;
    protected HashMap<String, Double> skewness;
    protected HashMap<String, Double> kurtosis;
    protected HashMap<String, HashMap<String, Double>> covariances;

    RunningStats() {
        this.init();
    }

    RunningStats(String[] fieldNames, double[] fieldVals) {
        if (fieldVals != null && fieldVals.length > 0) {
            this.init();
            this.add(fieldNames, fieldVals);
        }
    }

    private void init() {
        this.counts = new HashMap();
        this.fieldSum = new HashMap();
        this.means = new HashMap();
        this.skewness = new HashMap();
        this.kurtosis = new HashMap();
        this.covariances = new HashMap();
        this.variances = new HashMap();
    }

    public RunningStats(StreamInput in) throws IOException {
        this();
        this.docCount = (Long)in.readGenericValue();
        this.fieldSum = RunningStats.convertIfNeeded((Map)in.readGenericValue());
        this.counts = RunningStats.convertIfNeeded((Map)in.readGenericValue());
        this.means = RunningStats.convertIfNeeded((Map)in.readGenericValue());
        this.variances = RunningStats.convertIfNeeded((Map)in.readGenericValue());
        this.skewness = RunningStats.convertIfNeeded((Map)in.readGenericValue());
        this.kurtosis = RunningStats.convertIfNeeded((Map)in.readGenericValue());
        this.covariances = RunningStats.convertIfNeeded((Map)in.readGenericValue());
    }

    private static <K, V> HashMap<K, V> convertIfNeeded(Map<K, V> map) {
        if (map instanceof HashMap) {
            return (HashMap)map;
        }
        return new HashMap<K, V>(map);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue((Object)this.docCount);
        out.writeGenericValue(this.fieldSum);
        out.writeGenericValue(this.counts);
        out.writeGenericValue(this.means);
        out.writeGenericValue(this.variances);
        out.writeGenericValue(this.skewness);
        out.writeGenericValue(this.kurtosis);
        out.writeGenericValue(this.covariances);
    }

    public void add(String[] fieldNames, double[] fieldVals) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("Cannot add statistics without field names.");
        }
        if (fieldVals == null) {
            throw new IllegalArgumentException("Cannot add statistics without field values.");
        }
        if (fieldNames.length != fieldVals.length) {
            throw new IllegalArgumentException("Number of field values do not match number of field names.");
        }
        ++this.docCount;
        HashMap<String, Double> deltas = new HashMap<String, Double>();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            double fieldValue = fieldVals[i];
            this.counts.put(fieldName, 1L + (this.counts.containsKey(fieldName) ? this.counts.get(fieldName) : 0L));
            this.fieldSum.put(fieldName, fieldValue + (this.fieldSum.containsKey(fieldName) ? this.fieldSum.get(fieldName) : 0.0));
            deltas.put(fieldName, fieldValue * (double)this.docCount - this.fieldSum.get(fieldName));
            if (this.means.containsKey(fieldName)) {
                double m1 = this.means.get(fieldName);
                double d = fieldValue - m1;
                this.means.put(fieldName, m1 + d / (double)this.docCount);
                double dn = d / (double)this.docCount;
                double t1 = d * dn * (double)(this.docCount - 1L);
                double m2 = this.variances.get(fieldName);
                this.variances.put(fieldName, m2 + t1);
                double m3 = this.skewness.get(fieldName);
                this.skewness.put(fieldName, m3 + (t1 * dn * ((double)this.docCount - 2.0) - 3.0 * dn * m2));
                double dn2 = dn * dn;
                double m4 = t1 * dn2 * ((double)(this.docCount * this.docCount) - 3.0 * (double)this.docCount + 3.0) + 6.0 * dn2 * m2 - 4.0 * dn * m3;
                this.kurtosis.put(fieldName, this.kurtosis.get(fieldName) + m4);
                continue;
            }
            this.means.put(fieldName, fieldValue);
            this.variances.put(fieldName, 0.0);
            this.skewness.put(fieldName, 0.0);
            this.kurtosis.put(fieldName, 0.0);
        }
        this.updateCovariance(fieldNames, deltas);
    }

    private void updateCovariance(String[] fieldNames, Map<String, Double> deltas) {
        ArrayList<String> cFieldNames = new ArrayList<String>(Arrays.asList(fieldNames));
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            cFieldNames.remove(fieldName);
            double dR = deltas.get(fieldName);
            HashMap<String, Double> cFieldVals = this.covariances.get(fieldName) != null ? this.covariances.get(fieldName) : new HashMap<String, Double>();
            for (String cFieldName : cFieldNames) {
                if (cFieldVals.containsKey(cFieldName)) {
                    double newVal = (Double)cFieldVals.get(cFieldName) + 1.0 / ((double)this.docCount * ((double)this.docCount - 1.0)) * dR * deltas.get(cFieldName);
                    cFieldVals.put(cFieldName, newVal);
                    continue;
                }
                cFieldVals.put(cFieldName, 0.0);
            }
            if (cFieldVals.size() <= 0) continue;
            this.covariances.put(fieldName, cFieldVals);
        }
    }

    public Set<String> missingFieldNames(RunningStats other) {
        if (other == null || this.docCount == 0L || other.docCount == 0L) {
            return Collections.emptySet();
        }
        return RunningStats.symmetricDifference(this.getAllFieldNames(), other.getAllFieldNames());
    }

    private static <T> Set<T> symmetricDifference(Set<T> a, Set<T> b) {
        HashSet result = new HashSet();
        result.addAll(Sets.difference(a, b));
        result.addAll(Sets.difference(b, a));
        return result;
    }

    public void merge(RunningStats other) {
        if (other == null) {
            return;
        }
        if (this.docCount == 0L) {
            for (Map.Entry<String, Double> fs : other.means.entrySet()) {
                String fieldName = fs.getKey();
                this.means.put(fieldName, (double)fs.getValue());
                this.counts.put(fieldName, (long)other.counts.get(fieldName));
                this.fieldSum.put(fieldName, (double)other.fieldSum.get(fieldName));
                this.variances.put(fieldName, (double)other.variances.get(fieldName));
                this.skewness.put(fieldName, (double)other.skewness.get(fieldName));
                this.kurtosis.put(fieldName, (double)other.kurtosis.get(fieldName));
                if (other.covariances.containsKey(fieldName)) {
                    this.covariances.put(fieldName, other.covariances.get(fieldName));
                }
                this.docCount = other.docCount;
            }
            return;
        }
        double nA = this.docCount;
        double nB = other.docCount;
        this.docCount += other.docCount;
        HashMap<String, Double> deltas = new HashMap<String, Double>();
        for (Map.Entry<String, Double> fs : other.means.entrySet()) {
            String fieldName = fs.getKey();
            double meanA = this.means.get(fieldName);
            double varA = this.variances.get(fieldName);
            double skewA = this.skewness.get(fieldName);
            double kurtA = this.kurtosis.get(fieldName);
            double meanB = other.means.get(fieldName);
            double varB = other.variances.get(fieldName);
            double skewB = other.skewness.get(fieldName);
            double kurtB = other.kurtosis.get(fieldName);
            this.counts.put(fieldName, this.counts.get(fieldName) + other.counts.get(fieldName));
            this.means.put(fieldName, (nA * this.means.get(fieldName) + nB * other.means.get(fieldName)) / (nA + nB));
            deltas.put(fieldName, other.fieldSum.get(fieldName) / nB - this.fieldSum.get(fieldName) / nA);
            this.fieldSum.put(fieldName, this.fieldSum.get(fieldName) + other.fieldSum.get(fieldName));
            double d = meanB - meanA;
            double d2 = d * d;
            double d3 = d * d2;
            double d4 = d2 * d2;
            double n2 = this.docCount * this.docCount;
            double nA2 = nA * nA;
            double nB2 = nB * nB;
            this.variances.put(fieldName, varA + varB + d2 * nA * (double)other.docCount / (double)this.docCount);
            double newSkew = skewA + skewB + d3 * nA * nB * (nA - nB) / n2;
            this.skewness.put(fieldName, newSkew + 3.0 * d * (nA * varB - nB * varA) / (double)this.docCount);
            double nk = kurtA + kurtB + d4 * nA * nB * (nA2 - nA * nB + nB2) / (n2 * (double)this.docCount);
            this.kurtosis.put(fieldName, nk + 6.0 * d2 * (nA2 * varB + nB2 * varA) / n2 + 4.0 * d * (nA * skewB - nB * skewA) / (double)this.docCount);
        }
        this.mergeCovariance(other, deltas);
    }

    private void mergeCovariance(RunningStats other, Map<String, Double> deltas) {
        double countA = this.docCount - other.docCount;
        for (Map.Entry<String, Double> fs : other.means.entrySet()) {
            String fieldName = fs.getKey();
            double f = countA * (double)other.docCount / (double)this.docCount;
            double dR = deltas.get(fieldName);
            if (!this.covariances.containsKey(fieldName)) continue;
            HashMap<String, Double> cFieldVals = this.covariances.get(fieldName);
            for (String cFieldName : cFieldVals.keySet()) {
                double newVal = cFieldVals.get(cFieldName);
                newVal = other.covariances.containsKey(fieldName) && other.covariances.get(fieldName).containsKey(cFieldName) ? (newVal += other.covariances.get(fieldName).get(cFieldName) + f * dR * deltas.get(cFieldName)) : (newVal += other.covariances.get(cFieldName).get(fieldName) + f * dR * deltas.get(cFieldName));
                cFieldVals.put(cFieldName, newVal);
            }
            this.covariances.put(fieldName, cFieldVals);
        }
    }

    public RunningStats clone() {
        try {
            return (RunningStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ElasticsearchException("Error trying to create a copy of RunningStats", new Object[0]);
        }
    }

    public Set<String> getAllFieldNames() {
        Set<String> allFieldNames = Collections.unmodifiableSet(this.counts.keySet());
        assert (allFieldNames.containsAll(this.variances.keySet()) && this.variances.keySet().containsAll(allFieldNames) && allFieldNames.containsAll(this.fieldSum.keySet()) && this.fieldSum.keySet().containsAll(allFieldNames) && allFieldNames.containsAll(this.means.keySet()) && this.means.keySet().containsAll(allFieldNames) && allFieldNames.containsAll(this.kurtosis.keySet()) && this.kurtosis.keySet().containsAll(allFieldNames) && allFieldNames.containsAll(this.skewness.keySet()) && this.skewness.keySet().containsAll(allFieldNames));
        return allFieldNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunningStats that = (RunningStats)o;
        return this.docCount == that.docCount && Objects.equals(this.fieldSum, that.fieldSum) && Objects.equals(this.counts, that.counts) && Objects.equals(this.means, that.means) && Objects.equals(this.variances, that.variances) && Objects.equals(this.skewness, that.skewness) && Objects.equals(this.kurtosis, that.kurtosis) && Objects.equals(this.covariances, that.covariances);
    }

    public int hashCode() {
        return Objects.hash(this.docCount, this.fieldSum, this.counts, this.means, this.variances, this.skewness, this.kurtosis, this.covariances);
    }
}

