/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class SearchTemplateRequest
extends ActionRequest
implements CompositeIndicesRequest,
ToXContentObject {
    private SearchRequest request;
    private boolean simulate = false;
    private boolean explain = false;
    private boolean profile = false;
    private ScriptType scriptType;
    private String script;
    private Map<String, Object> scriptParams;
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField SOURCE_FIELD = new ParseField("source", new String[]{"inline", "template"});
    private static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    private static final ParseField EXPLAIN_FIELD = new ParseField("explain", new String[0]);
    private static final ParseField PROFILE_FIELD = new ParseField("profile", new String[0]);
    private static final ObjectParser<SearchTemplateRequest, Void> PARSER = new ObjectParser("search_template");

    public SearchTemplateRequest() {
    }

    public SearchTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.request = (SearchRequest)in.readOptionalWriteable(SearchRequest::new);
        this.simulate = in.readBoolean();
        this.explain = in.readBoolean();
        this.profile = in.readBoolean();
        this.scriptType = ScriptType.readFrom((StreamInput)in);
        this.script = in.readOptionalString();
        if (in.readBoolean()) {
            this.scriptParams = in.readMap();
        }
    }

    public SearchTemplateRequest(SearchRequest searchRequest) {
        this.request = searchRequest;
    }

    public void setRequest(SearchRequest request) {
        this.request = request;
    }

    public SearchRequest getRequest() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SearchTemplateRequest request1 = (SearchTemplateRequest)((Object)o);
        return this.simulate == request1.simulate && this.explain == request1.explain && this.profile == request1.profile && Objects.equals(this.request, request1.request) && this.scriptType == request1.scriptType && Objects.equals(this.script, request1.script) && Objects.equals(this.scriptParams, request1.scriptParams);
    }

    public int hashCode() {
        return Objects.hash(this.request, this.simulate, this.explain, this.profile, this.scriptType, this.script, this.scriptParams);
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Map<String, Object> getScriptParams() {
        return this.scriptParams;
    }

    public void setScriptParams(Map<String, Object> scriptParams) {
        this.scriptParams = scriptParams;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.script == null || this.script.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"template is missing", validationException);
        }
        if (this.scriptType == null) {
            validationException = ValidateActions.addValidationError((String)"template's script type is missing", (ActionRequestValidationException)validationException);
        }
        if (!this.simulate) {
            if (this.request == null) {
                validationException = ValidateActions.addValidationError((String)"search request is missing", (ActionRequestValidationException)validationException);
            } else {
                ActionRequestValidationException ex = this.request.validate();
                if (ex != null) {
                    if (validationException == null) {
                        validationException = new ActionRequestValidationException();
                    }
                    validationException.addValidationErrors((Iterable)ex.validationErrors());
                }
            }
        }
        return validationException;
    }

    public static SearchTemplateRequest fromXContent(XContentParser parser) throws IOException {
        return (SearchTemplateRequest)((Object)PARSER.parse(parser, (Object)new SearchTemplateRequest(), null));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.scriptType == ScriptType.STORED) {
            builder.field(ID_FIELD.getPreferredName(), this.script);
        } else if (this.scriptType == ScriptType.INLINE) {
            builder.field(SOURCE_FIELD.getPreferredName(), this.script);
        } else {
            throw new UnsupportedOperationException("Unrecognized script type [" + this.scriptType + "].");
        }
        return builder.field(PARAMS_FIELD.getPreferredName(), this.scriptParams).field(EXPLAIN_FIELD.getPreferredName(), this.explain).field(PROFILE_FIELD.getPreferredName(), this.profile).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.request);
        out.writeBoolean(this.simulate);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.profile);
        this.scriptType.writeTo(out);
        out.writeOptionalString(this.script);
        boolean hasParams = this.scriptParams != null;
        out.writeBoolean(hasParams);
        if (hasParams) {
            out.writeGenericMap(this.scriptParams);
        }
    }

    static {
        PARSER.declareField((parser, request, s) -> request.setScriptParams(parser.map()), PARAMS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareString((request, s) -> {
            request.setScriptType(ScriptType.STORED);
            request.setScript((String)s);
        }, ID_FIELD);
        PARSER.declareBoolean(SearchTemplateRequest::setExplain, EXPLAIN_FIELD);
        PARSER.declareBoolean(SearchTemplateRequest::setProfile, PROFILE_FIELD);
        PARSER.declareField((parser, request, value) -> {
            block9: {
                request.setScriptType(ScriptType.INLINE);
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                        request.setScript(Strings.toString((XContentBuilder)builder.copyCurrentStructure(parser)));
                        break block9;
                    }
                    catch (IOException e) {
                        throw new ParsingException(parser.getTokenLocation(), "Could not parse inline template", (Throwable)e, new Object[0]);
                    }
                }
                request.setScript(parser.text());
            }
        }, SOURCE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
    }
}

