/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation.decider;

import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class SearchableSnapshotEnableAllocationDecider
extends AllocationDecider {
    static final String NAME = "searchable_snapshots_enable";
    public static final Setting<Boolean> SEARCHABLE_SNAPSHOTS_ALLOCATE_ON_ROLLING_RESTART = Setting.boolSetting((String)"xpack.searchable.snapshot.allocate_on_rolling_restart", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    private volatile EnableAllocationDecider.Allocation enableAllocation;
    private volatile boolean allocateOnRollingRestart;

    public SearchableSnapshotEnableAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.enableAllocation = (EnableAllocationDecider.Allocation)EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.get(settings);
        this.allocateOnRollingRestart = (Boolean)SEARCHABLE_SNAPSHOTS_ALLOCATE_ON_ROLLING_RESTART.get(settings);
        clusterSettings.addSettingsUpdateConsumer(EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING, this::setEnableAllocation);
        clusterSettings.addSettingsUpdateConsumer(SEARCHABLE_SNAPSHOTS_ALLOCATE_ON_ROLLING_RESTART, this::setAllocateOnRollingRestart);
    }

    private void setEnableAllocation(EnableAllocationDecider.Allocation allocation) {
        this.enableAllocation = allocation;
    }

    private void setAllocateOnRollingRestart(boolean allocateOnRollingRestart) {
        this.allocateOnRollingRestart = allocateOnRollingRestart;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (allocation.isSimulating()) {
            return allocation.decision(Decision.YES, NAME, "allocation is always enabled when simulating", new Object[0]);
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        if (indexMetadata.isSearchableSnapshot()) {
            EnableAllocationDecider.Allocation enableAllocationCopy = this.enableAllocation;
            boolean allocateOnRollingRestartCopy = this.allocateOnRollingRestart;
            if (enableAllocationCopy == EnableAllocationDecider.Allocation.PRIMARIES) {
                if (!allocateOnRollingRestartCopy) {
                    return allocation.decision(Decision.NO, NAME, "no allocations of searchable snapshots allowed during rolling restart due to [%s=%s] and [%s=false]", new Object[]{EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.getKey(), enableAllocationCopy, SEARCHABLE_SNAPSHOTS_ALLOCATE_ON_ROLLING_RESTART.getKey()});
                }
                return allocation.decision(Decision.YES, NAME, "allocate on rolling restart enabled [%s=true]", new Object[]{SEARCHABLE_SNAPSHOTS_ALLOCATE_ON_ROLLING_RESTART.getKey()});
            }
            return allocation.decision(Decision.YES, NAME, "decider only active during rolling restarts [%s=primaries]", new Object[]{EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.getKey()});
        }
        return allocation.decision(Decision.YES, NAME, "decider only applicable for indices backed by searchable snapshots", new Object[0]);
    }

    static {
        assert (Version.CURRENT.major == Version.V_7_17_0.major + 1);
    }
}

