/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action.cache;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.FrozenCacheInfoNodeAction;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.FrozenCacheInfoResponse;

public class FrozenCacheInfoAction
extends ActionType<FrozenCacheInfoResponse> {
    public static final String NAME = "internal:admin/xpack/searchable_snapshots/frozen_cache_info";
    public static final FrozenCacheInfoAction INSTANCE = new FrozenCacheInfoAction();

    private FrozenCacheInfoAction() {
        super(NAME, FrozenCacheInfoResponse::new);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, FrozenCacheInfoResponse> {
        private final FrozenCacheInfoNodeAction.Request nodeRequest = new FrozenCacheInfoNodeAction.Request();
        private final TransportService transportService;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters) {
            super(FrozenCacheInfoAction.NAME, transportService, actionFilters, Request::new);
            this.transportService = transportService;
        }

        protected void doExecute(Task task, Request request, ActionListener<FrozenCacheInfoResponse> listener) {
            if (request.discoveryNode.getVersion().onOrAfter((VersionId)Version.V_7_12_0)) {
                this.transportService.sendChildRequest(request.discoveryNode, "internal:admin/xpack/searchable_snapshots/frozen_cache_info[n]", (TransportRequest)this.nodeRequest, task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, FrozenCacheInfoResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
            } else {
                listener.onResponse((Object)new FrozenCacheInfoResponse(false));
            }
        }
    }

    public static class Request
    extends ActionRequest {
        private final DiscoveryNode discoveryNode;

        public Request(DiscoveryNode discoveryNode) {
            this.discoveryNode = discoveryNode;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.discoveryNode = new DiscoveryNode(in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getDescription() {
            return this.discoveryNode.toString();
        }
    }
}

