/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.NodesOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class NodesDeprecationCheckAction
extends ActionType<NodesDeprecationCheckResponse> {
    public static final NodesDeprecationCheckAction INSTANCE = new NodesDeprecationCheckAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/nodes/info";

    private NodesDeprecationCheckAction() {
        super(NAME, NodesDeprecationCheckResponse::new);
    }

    public static class RequestBuilder
    extends NodesOperationRequestBuilder<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, ActionType<NodesDeprecationCheckResponse> action, NodesDeprecationCheckRequest request) {
            super(client, action, (BaseNodesRequest)request);
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final List<DeprecationIssue> deprecationIssues;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.deprecationIssues = in.readList(DeprecationIssue::new);
        }

        public NodeResponse(DiscoveryNode node, List<DeprecationIssue> deprecationIssues) {
            super(node);
            this.deprecationIssues = deprecationIssues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.deprecationIssues);
        }

        public List<DeprecationIssue> getDeprecationIssues() {
            return this.deprecationIssues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)((Object)o);
            return Objects.equals(this.getDeprecationIssues(), that.getDeprecationIssues()) && Objects.equals(this.getNode(), that.getNode());
        }

        public int hashCode() {
            return Objects.hash(this.getNode(), this.getDeprecationIssues());
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        NodesDeprecationCheckRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesDeprecationCheckRequest(in);
        }

        public NodeRequest(NodesDeprecationCheckRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

