/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.LegacyFormatNames;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.frozen.FrozenEngine;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    static DeprecationIssue oldIndicesCheck(IndexMetadata indexMetadata) {
        IndexVersion currentCompatibilityVersion = indexMetadata.getCompatibilityVersion();
        if (currentCompatibilityVersion.before((VersionId)IndexVersion.V_7_0_0)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Old index with a compatibility version < 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html", "This index has version: " + currentCompatibilityVersion, false, null);
        }
        return null;
    }

    static DeprecationIssue translogRetentionSettingCheck(IndexMetadata indexMetadata) {
        boolean softDeletesEnabled = (Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings());
        if (softDeletesEnabled && (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetadata.getSettings()) || IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetadata.getSettings()))) {
            ArrayList<String> settingKeys = new ArrayList<String>();
            if (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetadata.getSettings())) {
                settingKeys.add(IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.getKey());
            }
            if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetadata.getSettings())) {
                settingKeys.add(IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.getKey());
            }
            Map meta = DeprecationIssue.createMetaMapForRemovableSettings(settingKeys);
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "translog retention settings are ignored", "https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules-translog.html", "translog retention settings [index.translog.retention.size] and [index.translog.retention.age] are ignored because translog is no longer used in peer recoveries with soft-deletes enabled (default in 7.0 or later)", false, meta);
        }
        return null;
    }

    static DeprecationIssue checkIndexDataPath(IndexMetadata indexMetadata) {
        if (IndexMetadata.INDEX_DATA_PATH_SETTING.exists(indexMetadata.getSettings())) {
            String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in a future version", IndexMetadata.INDEX_DATA_PATH_SETTING.getKey());
            String url = "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting";
            String details = "Found index data path configured. Discontinue use of this setting.";
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting", "Found index data path configured. Discontinue use of this setting.", false, null);
        }
        return null;
    }

    static DeprecationIssue storeTypeSettingCheck(IndexMetadata indexMetadata) {
        String storeType = (String)IndexModule.INDEX_STORE_TYPE_SETTING.get(indexMetadata.getSettings());
        if (IndexModule.Type.SIMPLEFS.match(storeType)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "[simplefs] is deprecated and will be removed in future versions", "https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules-store.html", "[simplefs] is deprecated and will be removed in 8.0. Use [niofs] or other file systems instead. Elasticsearch 7.15 or later uses [niofs] for the [simplefs] store type as it offers superior or equivalent performance to [simplefs].", false, null);
        }
        return null;
    }

    static DeprecationIssue frozenIndexSettingCheck(IndexMetadata indexMetadata) {
        Boolean isIndexFrozen = (Boolean)FrozenEngine.INDEX_FROZEN.get(indexMetadata.getSettings());
        if (Boolean.TRUE.equals(isIndexFrozen)) {
            String indexName = indexMetadata.getIndex().getName();
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "index [" + indexName + "] is a frozen index. The frozen indices feature is deprecated and will be removed in a future version", "https://www.elastic.co/guide/en/elasticsearch/reference/master/frozen-indices.html", "Frozen indices no longer offer any advantages. Consider cold or frozen tiers in place of frozen indices.", false, null);
        }
        return null;
    }

    private static void fieldLevelMappingIssue(IndexMetadata indexMetadata, BiConsumer<MappingMetadata, Map<String, Object>> checker) {
        if (indexMetadata.mapping() != null) {
            Map sourceAsMap = indexMetadata.mapping().sourceAsMap();
            checker.accept(indexMetadata.mapping(), sourceAsMap);
        }
    }

    static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter, String fieldBeginMarker, String fieldEndMarker) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + fieldEndMarker);
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + ", multifield: " + multifieldEntry.getKey() + fieldEndMarker);
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
        }
        return issues;
    }

    static DeprecationIssue deprecatedCamelCasePattern(IndexMetadata indexMetadata) {
        ArrayList fields = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> fields.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetadata.type(), sourceAsMap, IndexDeprecationChecks::isDateFieldWithCamelCasePattern, IndexDeprecationChecks::changeFormatToSnakeCase, "", "")));
        if (fields.size() > 0) {
            String detailsMessageBeginning = String.join((CharSequence)" ", fields);
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Date fields use deprecated camel case formats", "https://ela.st/es-deprecation-7-camel-case-format", detailsMessageBeginning, false, null);
        }
        return null;
    }

    private static boolean isDateFieldWithCamelCasePattern(Map<?, ?> property) {
        String[] patterns;
        String[] stringArray;
        int n;
        int n2;
        if ("date".equals(property.get("type")) && property.containsKey("format") && (n2 = 0) < (n = (stringArray = (patterns = DateFormatter.splitCombinedPatterns((String)((String)property.get("format"))))).length)) {
            String pattern = stringArray[n2];
            LegacyFormatNames format = LegacyFormatNames.forName((String)pattern);
            return format != null && format.isCamelCase(pattern);
        }
        return false;
    }

    private static String changeFormatToSnakeCase(String type, Map.Entry<?, ?> entry) {
        Map value = (Map)entry.getValue();
        String formatFieldValue = (String)value.get("format");
        String[] patterns = DateFormatter.splitCombinedPatterns((String)formatFieldValue);
        StringBuilder sb = new StringBuilder("Convert [" + entry.getKey() + "] format [" + formatFieldValue + "] which contains deprecated camel case to snake case. ");
        for (String pattern : patterns) {
            LegacyFormatNames format = LegacyFormatNames.forName((String)pattern);
            if (format == null || !format.isCamelCase(pattern)) continue;
            sb.append("[" + pattern + "] to [" + format.getSnakeCaseName() + "]. ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

