/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.SuppressForbidden;

@SuppressForbidden(reason="Lucene class")
public class OldSegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public static final int VERSION_53 = 6;
    public static final int VERSION_70 = 7;
    public static final int VERSION_72 = 8;
    public static final int VERSION_74 = 9;
    public static final int VERSION_86 = 10;
    static final int VERSION_CURRENT = 10;
    private static final String OLD_SEGMENTS_GEN = "segments.gen";
    public long counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    private byte[] id;
    private Version luceneVersion;
    private Version minSegmentLuceneVersion;
    private final int indexCreatedVersionMajor;
    boolean pendingCommit;

    public OldSegmentInfos(int indexCreatedVersionMajor) {
        if (indexCreatedVersionMajor > Version.LATEST.major) {
            throw new IllegalArgumentException("indexCreatedVersionMajor is in the future: " + indexCreatedVersionMajor);
        }
        if (indexCreatedVersionMajor < 6) {
            throw new IllegalArgumentException("indexCreatedVersionMajor must be >= 6, got: " + indexCreatedVersionMajor);
        }
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
    }

    public SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    public static long getLastCommitGeneration(String[] files) {
        long max = -1L;
        for (String file : files) {
            long gen;
            if (!file.startsWith("segments") || file.startsWith(OLD_SEGMENTS_GEN) || (gen = OldSegmentInfos.generationFromSegmentsFileName(file)) <= max) continue;
            max = gen;
        }
        return max;
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration((String)"segments", (String)"", (long)this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals(OLD_SEGMENTS_GEN)) {
            throw new IllegalArgumentException("\"segments.gen\" is not a valid segment file name since 4.0");
        }
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    static final OldSegmentInfos readCommit(Directory directory, String segmentFileName, int minSupportedMajorVersion) throws IOException {
        long generation = OldSegmentInfos.generationFromSegmentsFileName(segmentFileName);
        ChecksumIndexInput input = directory.openChecksumInput(segmentFileName, IOContext.READ);
        try {
            OldSegmentInfos oldSegmentInfos = OldSegmentInfos.readCommit(directory, input, generation, minSupportedMajorVersion);
            return oldSegmentInfos;
        }
        catch (EOFException | FileNotFoundException | NoSuchFileException e) {
            throw new CorruptIndexException("Unexpected file read error while reading index.", (DataInput)input, (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final OldSegmentInfos readCommit(Directory directory, ChecksumIndexInput input, long generation, int minSupportedMajorVersion) throws IOException {
        Throwable priorE = null;
        int format = -1;
        try {
            int magic = CodecUtil.readBEInt((DataInput)input);
            if (magic != 1071082519) {
                throw new IndexFormatTooOldException((DataInput)input, magic, 1071082519, 1071082519);
            }
            format = CodecUtil.checkHeaderNoMagic((DataInput)input, (String)"segments", (int)6, (int)10);
            byte[] id = new byte[16];
            input.readBytes(id, 0, id.length);
            CodecUtil.checkIndexHeaderSuffix((DataInput)input, (String)Long.toString(generation, 36));
            Version luceneVersion = Version.fromBits((int)input.readVInt(), (int)input.readVInt(), (int)input.readVInt());
            int indexCreatedVersion = 6;
            if (format >= 7) {
                indexCreatedVersion = input.readVInt();
            }
            if (luceneVersion.major < indexCreatedVersion) {
                throw new CorruptIndexException("Creation version [" + indexCreatedVersion + ".x] can't be greater than the version that wrote the segment infos: [" + luceneVersion + "]", (DataInput)input);
            }
            if (indexCreatedVersion < minSupportedMajorVersion) {
                throw new IndexFormatTooOldException((DataInput)input, "This index was initially created with Lucene " + indexCreatedVersion + ".x while the current version is " + Version.LATEST + " and Lucene only supports reading" + (String)(minSupportedMajorVersion == Version.MIN_SUPPORTED_MAJOR ? " the current and previous major versions" : " from version " + minSupportedMajorVersion + " upwards"));
            }
            OldSegmentInfos infos = new OldSegmentInfos(indexCreatedVersion);
            infos.id = id;
            infos.generation = generation;
            infos.lastGeneration = generation;
            infos.luceneVersion = luceneVersion;
            OldSegmentInfos.parseSegmentInfos(directory, (DataInput)input, infos, format);
            OldSegmentInfos oldSegmentInfos = infos;
            return oldSegmentInfos;
        }
        catch (Throwable t) {
            priorE = t;
        }
        finally {
            if (format < 6) {
                throw IOUtils.rethrowAlways((Throwable)priorE);
            }
            CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
        }
        throw new Error("Unreachable code");
    }

    private static void parseSegmentInfos(Directory directory, DataInput input, OldSegmentInfos infos, int format) throws IOException {
        infos.version = CodecUtil.readBELong((DataInput)input);
        infos.counter = format > 7 ? input.readVLong() : (long)CodecUtil.readBEInt((DataInput)input);
        int numSegments = CodecUtil.readBEInt((DataInput)input);
        if (numSegments < 0) {
            throw new CorruptIndexException("invalid segment count: " + numSegments, input);
        }
        if (numSegments > 0) {
            infos.minSegmentLuceneVersion = Version.fromBits((int)input.readVInt(), (int)input.readVInt(), (int)input.readVInt());
        }
        long totalDocs = 0L;
        for (int seg = 0; seg < numSegments; ++seg) {
            Map dvUpdateFiles;
            byte[] sciId;
            int softDelCount;
            String segName = input.readString();
            if (format < 7) {
                byte hasID = input.readByte();
                if (hasID == 0) {
                    throw new IndexFormatTooOldException(input, "Segment is from Lucene 4.x");
                }
                if (hasID != 1) {
                    throw new CorruptIndexException("invalid hasID byte, got: " + hasID, input);
                }
            }
            byte[] segmentID = new byte[16];
            input.readBytes(segmentID, 0, segmentID.length);
            Codec codec = OldSegmentInfos.readCodec(input);
            SegmentInfo info = codec.segmentInfoFormat().read(directory, segName, segmentID, IOContext.READ);
            info.setCodec(codec);
            totalDocs += (long)info.maxDoc();
            long delGen = CodecUtil.readBELong((DataInput)input);
            int delCount = CodecUtil.readBEInt((DataInput)input);
            if (delCount < 0 || delCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + delCount + " vs maxDoc=" + info.maxDoc(), input);
            }
            long fieldInfosGen = CodecUtil.readBELong((DataInput)input);
            long dvGen = CodecUtil.readBELong((DataInput)input);
            int n = softDelCount = format > 8 ? CodecUtil.readBEInt((DataInput)input) : 0;
            if (softDelCount < 0 || softDelCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + softDelCount + " vs maxDoc=" + info.maxDoc(), input);
            }
            if (softDelCount + delCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + (softDelCount + delCount) + " vs maxDoc=" + info.maxDoc(), input);
            }
            if (format > 9) {
                byte marker = input.readByte();
                switch (marker) {
                    case 1: {
                        sciId = new byte[16];
                        input.readBytes(sciId, 0, sciId.length);
                        break;
                    }
                    case 0: {
                        sciId = null;
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("invalid SegmentCommitInfo ID marker: " + marker, input);
                    }
                }
            } else {
                sciId = null;
            }
            SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info, delCount, softDelCount, delGen, fieldInfosGen, dvGen, sciId);
            siPerCommit.setFieldInfosFiles(input.readSetOfStrings());
            int numDVFields = CodecUtil.readBEInt((DataInput)input);
            if (numDVFields == 0) {
                dvUpdateFiles = Collections.emptyMap();
            } else {
                Map map = Maps.newMapWithExpectedSize((int)numDVFields);
                for (int i = 0; i < numDVFields; ++i) {
                    map.put(CodecUtil.readBEInt((DataInput)input), input.readSetOfStrings());
                }
                dvUpdateFiles = Collections.unmodifiableMap(map);
            }
            siPerCommit.setDocValuesUpdatesFiles(dvUpdateFiles);
            infos.add(siPerCommit);
            Version segmentVersion = info.getVersion();
            if (!segmentVersion.onOrAfter(infos.minSegmentLuceneVersion)) {
                throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + infos.minSegmentLuceneVersion + " but segment=" + info + " has older version=" + segmentVersion, input);
            }
            if (infos.indexCreatedVersionMajor >= 7 && segmentVersion.major < infos.indexCreatedVersionMajor) {
                throw new CorruptIndexException("segments file recorded indexCreatedVersionMajor=" + infos.indexCreatedVersionMajor + " but segment=" + info + " has older version=" + segmentVersion, input);
            }
            if (infos.indexCreatedVersionMajor < 7 || info.getMinVersion() != null) continue;
            throw new CorruptIndexException("segments infos must record minVersion with indexCreatedVersionMajor=" + infos.indexCreatedVersionMajor, input);
        }
        infos.userData = input.readMapOfStrings();
    }

    private static Codec readCodec(DataInput input) throws IOException {
        String name = input.readString();
        try {
            return Codec.forName((String)name);
        }
        catch (IllegalArgumentException e) {
            if (name.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + name + "'. Did you forget to add lucene-backward-codecs.jar?", e);
            }
            throw e;
        }
    }

    public static final OldSegmentInfos readLatestCommit(Directory directory) throws IOException {
        return OldSegmentInfos.readLatestCommit(directory, Version.MIN_SUPPORTED_MAJOR);
    }

    static final OldSegmentInfos readLatestCommit(Directory directory, final int minSupportedMajorVersion) throws IOException {
        return (OldSegmentInfos)new FindSegmentsFile<OldSegmentInfos>(directory){

            @Override
            protected OldSegmentInfos doBody(String segmentFileName) throws IOException {
                return OldSegmentInfos.readCommit(this.directory, segmentFileName, minSupportedMajorVersion);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Directory directory) throws IOException {
        IndexOutput segnOutput;
        String segmentFileName;
        block4: {
            long nextGeneration = this.getNextPendingGeneration();
            segmentFileName = IndexFileNames.fileNameFromGeneration((String)"pending_segments", (String)"", (long)nextGeneration);
            this.generation = nextGeneration;
            segnOutput = null;
            boolean success = false;
            try {
                segnOutput = directory.createOutput(segmentFileName, IOContext.DEFAULT);
                this.write(segnOutput);
                segnOutput.close();
                directory.sync(Collections.singleton(segmentFileName));
                success = true;
                if (!success) break block4;
                this.pendingCommit = true;
            }
            catch (Throwable throwable) {
                if (success) {
                    this.pendingCommit = true;
                } else {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{segnOutput});
                    IOUtils.deleteFilesIgnoringExceptions((Directory)directory, (String[])new String[]{segmentFileName});
                }
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{segnOutput});
        IOUtils.deleteFilesIgnoringExceptions((Directory)directory, (String[])new String[]{segmentFileName});
    }

    public void write(IndexOutput out) throws IOException {
        CodecUtil.writeIndexHeader((DataOutput)out, (String)"segments", (int)10, (byte[])StringHelper.randomId(), (String)Long.toString(this.generation, 36));
        out.writeVInt(Version.LATEST.major);
        out.writeVInt(Version.LATEST.minor);
        out.writeVInt(Version.LATEST.bugfix);
        out.writeVInt(this.indexCreatedVersionMajor);
        CodecUtil.writeBELong((DataOutput)out, (long)this.version);
        out.writeVLong(this.counter);
        CodecUtil.writeBEInt((DataOutput)out, (int)this.size());
        if (this.size() > 0) {
            Version minSegmentVersion = null;
            for (SegmentCommitInfo siPerCommit : this) {
                Version segmentVersion = siPerCommit.info.getVersion();
                if (minSegmentVersion != null && segmentVersion.onOrAfter(minSegmentVersion)) continue;
                minSegmentVersion = segmentVersion;
            }
            out.writeVInt(minSegmentVersion.major);
            out.writeVInt(minSegmentVersion.minor);
            out.writeVInt(minSegmentVersion.bugfix);
        }
        for (SegmentCommitInfo siPerCommit : this) {
            SegmentInfo si = siPerCommit.info;
            out.writeString(si.name);
            byte[] segmentID = si.getId();
            if (segmentID.length != 16) {
                throw new IllegalStateException("cannot write segment: invalid id segment=" + si.name + "id=" + StringHelper.idToString((byte[])segmentID));
            }
            out.writeBytes(segmentID, segmentID.length);
            out.writeString(si.getCodec().getName());
            CodecUtil.writeBELong((DataOutput)out, (long)siPerCommit.getDelGen());
            int delCount = siPerCommit.getDelCount();
            if (delCount < 0 || delCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " delCount=" + delCount);
            }
            CodecUtil.writeBEInt((DataOutput)out, (int)delCount);
            CodecUtil.writeBELong((DataOutput)out, (long)siPerCommit.getFieldInfosGen());
            CodecUtil.writeBELong((DataOutput)out, (long)siPerCommit.getDocValuesGen());
            int softDelCount = siPerCommit.getSoftDelCount();
            if (softDelCount < 0 || softDelCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " softDelCount=" + softDelCount);
            }
            CodecUtil.writeBEInt((DataOutput)out, (int)softDelCount);
            byte[] sciId = siPerCommit.getId();
            if (sciId != null) {
                out.writeByte((byte)1);
                assert (sciId.length == 16) : "invalid SegmentCommitInfo#id: " + Arrays.toString(sciId);
                out.writeBytes(sciId, 0, sciId.length);
            } else {
                out.writeByte((byte)0);
            }
            out.writeSetOfStrings(siPerCommit.getFieldInfosFiles());
            Map dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
            CodecUtil.writeBEInt((DataOutput)out, (int)dvUpdatesFiles.size());
            for (Map.Entry e : dvUpdatesFiles.entrySet()) {
                CodecUtil.writeBEInt((DataOutput)out, (int)((Integer)e.getKey()));
                out.writeSetOfStrings((Set)e.getValue());
            }
        }
        out.writeMapOfStrings(this.userData);
        CodecUtil.writeFooter((IndexOutput)out);
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    private static void message(String message) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
    }

    public Collection<String> files(boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files.add(segmentFileName);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SegmentCommitInfo info = this.info(i);
            files.addAll(info.files());
        }
        return files;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info = this.info(i);
            buffer.append(info.toString(0));
        }
        return buffer.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo si) {
        this.segments.add(si);
    }

    public static abstract class FindSegmentsFile<T> {
        final Directory directory;

        protected FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(IndexCommit commit) throws IOException {
            if (commit != null) {
                if (this.directory != commit.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(commit.getSegmentsFileName());
            }
            long lastGen = -1L;
            long gen = -1L;
            IOException exc = null;
            while (true) {
                lastGen = gen;
                Object[] files = this.directory.listAll();
                Object[] files2 = this.directory.listAll();
                Arrays.sort(files);
                Arrays.sort(files2);
                if (!Arrays.equals(files, files2)) continue;
                gen = OldSegmentInfos.getLastCommitGeneration((String[])files);
                if (infoStream != null) {
                    OldSegmentInfos.message("directory listing gen=" + gen);
                }
                if (gen == -1L) {
                    throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                }
                if (gen <= lastGen) break;
                String segmentFileName = IndexFileNames.fileNameFromGeneration((String)"segments", (String)"", (long)gen);
                try {
                    T t = this.doBody(segmentFileName);
                    if (infoStream != null) {
                        OldSegmentInfos.message("success on " + segmentFileName);
                    }
                    return t;
                }
                catch (IOException err) {
                    if (exc == null) {
                        exc = err;
                    }
                    if (infoStream == null) continue;
                    OldSegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: gen = " + gen);
                    continue;
                }
                break;
            }
            throw exc;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

