/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tracing.apm;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.TracerPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.tracing.apm.APMAgentSettings;
import org.elasticsearch.tracing.apm.APMTracer;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class APM
extends Plugin
implements NetworkPlugin,
TracerPlugin {
    private final SetOnce<APMTracer> tracer = new SetOnce();
    private final Settings settings;

    public APM(Settings settings) {
        this.settings = settings;
    }

    public Tracer getTracer(Settings settings) {
        APMTracer apmTracer = new APMTracer(settings);
        this.tracer.set((Object)apmTracer);
        return apmTracer;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, Tracer unused, AllocationService allocationService, IndicesService indicesService) {
        APMTracer apmTracer = (APMTracer)((Object)this.tracer.get());
        apmTracer.setClusterName(clusterService.getClusterName().value());
        apmTracer.setNodeName(clusterService.getNodeName());
        APMAgentSettings apmAgentSettings = new APMAgentSettings();
        apmAgentSettings.syncAgentSystemProperties(this.settings);
        apmAgentSettings.addClusterSettingsListeners(clusterService, apmTracer);
        return List.of(apmTracer);
    }

    public List<Setting<?>> getSettings() {
        return List.of(APMAgentSettings.APM_ENABLED_SETTING, APMAgentSettings.APM_TRACING_NAMES_INCLUDE_SETTING, APMAgentSettings.APM_TRACING_NAMES_EXCLUDE_SETTING, APMAgentSettings.APM_TRACING_SANITIZE_FIELD_NAMES, APMAgentSettings.APM_AGENT_SETTINGS, APMAgentSettings.APM_SECRET_TOKEN_SETTING, APMAgentSettings.APM_API_KEY_SETTING);
    }
}

