/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli.keystore;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.KeyStoreAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;

class CreateKeyStoreCommand
extends KeyStoreAwareCommand {
    private final OptionSpec<Void> passwordOption;

    CreateKeyStoreCommand() {
        super("Creates a new elasticsearch keystore");
        this.passwordOption = this.parser.acceptsAll(Arrays.asList("p", "password"), "Prompt for password to encrypt the keystore");
    }

    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        try (SecureString password = options.has(this.passwordOption) ? CreateKeyStoreCommand.readPassword((Terminal)terminal, (boolean)true) : new SecureString(new char[0]);){
            Path keystoreFile = KeyStoreWrapper.keystorePath((Path)env.configFile());
            if (Files.exists(keystoreFile, new LinkOption[0]) && !terminal.promptYesNo("An elasticsearch keystore already exists. Overwrite?", false)) {
                terminal.println((CharSequence)"Exiting without creating keystore.");
                return;
            }
            KeyStoreWrapper keystore = KeyStoreWrapper.create();
            keystore.save(env.configFile(), password.getChars());
            terminal.println((CharSequence)("Created elasticsearch keystore in " + KeyStoreWrapper.keystorePath((Path)env.configFile())));
        }
        catch (SecurityException e) {
            throw new UserException(74, "Error creating the elasticsearch keystore.");
        }
    }
}

