/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.regex;

import java.util.Objects;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.lucene.RegExp;
import org.elasticsearch.xpack.ql.expression.predicate.regex.AbstractStringPattern;

public class RLikePattern
extends AbstractStringPattern {
    private final String regexpPattern;

    public RLikePattern(String regexpPattern) {
        this.regexpPattern = regexpPattern;
    }

    @Override
    public Automaton createAutomaton() {
        return new RegExp(this.regexpPattern).toAutomaton();
    }

    @Override
    public String asJavaRegex() {
        return this.regexpPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RLikePattern that = (RLikePattern)o;
        return Objects.equals(this.regexpPattern, that.regexpPattern);
    }

    public int hashCode() {
        return Objects.hash(this.regexpPattern);
    }
}

