/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.analyzer.TableInfo;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    protected PreAnalysis doPreAnalyze(LogicalPlan plan) {
        ArrayList<TableInfo> indices = new ArrayList<TableInfo>();
        plan.forEachUp(UnresolvedRelation.class, p -> indices.add(new TableInfo(p.table(), p.frozen())));
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis(indices);
    }

    public static class PreAnalysis {
        public static final PreAnalysis EMPTY = new PreAnalysis(Collections.emptyList());
        public final List<TableInfo> indices;

        public PreAnalysis(List<TableInfo> indices) {
            this.indices = indices;
        }
    }
}

