/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.search;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.transform.search.ExecutableSearchTransform;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransform;

public class SearchTransformFactory
extends TransformFactory<SearchTransform, SearchTransform.Result, ExecutableSearchTransform> {
    private final Client client;
    private final TimeValue defaultTimeout;
    private final WatcherSearchTemplateService searchTemplateService;

    public SearchTransformFactory(Settings settings, Client client, NamedXContentRegistry xContentRegistry, ScriptService scriptService) {
        super(LogManager.getLogger(ExecutableSearchTransform.class));
        this.client = client;
        this.defaultTimeout = settings.getAsTime("xpack.watcher.transform.search.default_timeout", TimeValue.timeValueMinutes((long)1L));
        this.searchTemplateService = new WatcherSearchTemplateService(scriptService, xContentRegistry);
    }

    public String type() {
        return "search";
    }

    public SearchTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return SearchTransform.parse(watchId, parser);
    }

    public ExecutableSearchTransform createExecutable(SearchTransform transform) {
        return new ExecutableSearchTransform(transform, this.transformLogger, this.client, this.searchTemplateService, this.defaultTimeout);
    }
}

