/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.action;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.logstash.action.GetPipelineRequest;
import org.elasticsearch.xpack.logstash.action.GetPipelineResponse;

public class TransportGetPipelineAction
extends HandledTransportAction<GetPipelineRequest, GetPipelineResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetPipelineAction.class);
    private static final Integer SIZE = 10000;
    private static final String WILDCARD = "*";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("[^*]+|(\\*)");
    private final Client client;

    @Inject
    public TransportGetPipelineAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/logstash/pipeline/get", transportService, actionFilters, GetPipelineRequest::new);
        this.client = new OriginSettingClient(client, "logstash_management");
    }

    protected void doExecute(Task task, GetPipelineRequest request, ActionListener<GetPipelineResponse> listener) {
        Set<String> explicitPipelineIds = request.ids().stream().filter(pipeline -> !pipeline.contains(WILDCARD)).collect(Collectors.toSet());
        Set wildcardPipelinePatterns = request.ids().stream().filter(pipeline -> pipeline.contains(WILDCARD)).map(this::toWildcardPipelineIdPattern).map(Pattern::compile).collect(Collectors.toSet());
        if (explicitPipelineIds.size() > 0 && wildcardPipelinePatterns.size() == 0) {
            this.getPipelinesByIds(explicitPipelineIds, listener);
            return;
        }
        this.client.prepareSearch(new String[]{".logstash"}).setSource(SearchSourceBuilder.searchSource().fetchSource(true).query((QueryBuilder)QueryBuilders.matchAllQuery()).size(SIZE.intValue()).trackTotalHits(true)).setScroll(TimeValue.timeValueMinutes((long)1L)).execute(ActionListener.wrap(searchResponse -> {
            int numHits = Math.toIntExact(searchResponse.getHits().getTotalHits().value);
            Map pipelineSources = Maps.newMapWithExpectedSize((int)numHits);
            Consumer<SearchResponse> clearScroll = response -> {
                if (response != null && response.getScrollId() != null) {
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                    clearScrollRequest.addScrollId(response.getScrollId());
                    this.client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> {}, e -> logger.warn(() -> "clear scroll failed for scroll id [" + response.getScrollId() + "]", (Throwable)e)));
                }
            };
            this.handleFilteringSearchResponse((SearchResponse)searchResponse, pipelineSources, explicitPipelineIds, wildcardPipelinePatterns, 0, clearScroll, listener);
        }, e -> this.handleFailure((Exception)e, listener)));
    }

    private void getPipelinesByIds(Set<String> ids, ActionListener<GetPipelineResponse> listener) {
        this.client.prepareMultiGet().addIds(".logstash", ids).execute(ActionListener.wrap(mGetResponse -> {
            this.logFailures((MultiGetResponse)mGetResponse);
            listener.onResponse((Object)new GetPipelineResponse(Arrays.stream(mGetResponse.getResponses()).filter(itemResponse -> !itemResponse.isFailed()).map(MultiGetItemResponse::getResponse).filter(GetResponse::isExists).collect(Collectors.toMap(GetResponse::getId, GetResponse::getSourceAsBytesRef))));
        }, e -> this.handleFailure((Exception)e, listener)));
    }

    private void handleFailure(Exception e, ActionListener<GetPipelineResponse> listener) {
        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
        if (cause instanceof IndexNotFoundException) {
            listener.onResponse((Object)new GetPipelineResponse(Map.of()));
        } else {
            listener.onFailure(e);
        }
    }

    private void handleFilteringSearchResponse(SearchResponse searchResponse, Map<String, BytesReference> pipelineSources, Set<String> explicitPipelineIds, Set<Pattern> wildcardPipelinePatterns, int numberOfHitsSeenPreviously, Consumer<SearchResponse> clearScroll, ActionListener<GetPipelineResponse> listener) {
        int numberOfHitsSeenSoFar = numberOfHitsSeenPreviously + searchResponse.getHits().getHits().length;
        if ((long)numberOfHitsSeenSoFar > searchResponse.getHits().getTotalHits().value) {
            clearScroll.accept(searchResponse);
            listener.onFailure((Exception)new IllegalStateException("scrolling returned more hits [" + numberOfHitsSeenSoFar + "] than expected [" + searchResponse.getHits().getTotalHits().value + "] so bailing out to prevent unbounded memory consumption."));
        }
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            if (explicitPipelineIds.isEmpty() && wildcardPipelinePatterns.isEmpty()) {
                pipelineSources.put(hit.getId(), hit.getSourceRef());
                continue;
            }
            if (explicitPipelineIds.contains(hit.getId())) {
                pipelineSources.put(hit.getId(), hit.getSourceRef());
                continue;
            }
            if (!wildcardPipelinePatterns.stream().anyMatch(pattern -> pattern.matcher(hit.getId()).matches())) continue;
            pipelineSources.put(hit.getId(), hit.getSourceRef());
        }
        if ((long)numberOfHitsSeenSoFar == searchResponse.getHits().getTotalHits().value) {
            clearScroll.accept(searchResponse);
            listener.onResponse((Object)new GetPipelineResponse(pipelineSources));
        } else {
            this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(TimeValue.timeValueMinutes((long)1L)).execute(ActionListener.wrap(searchResponse1 -> this.handleFilteringSearchResponse((SearchResponse)searchResponse1, pipelineSources, explicitPipelineIds, wildcardPipelinePatterns, numberOfHitsSeenSoFar, clearScroll, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void logFailures(MultiGetResponse multiGetResponse) {
        List ids = Arrays.stream(multiGetResponse.getResponses()).filter(MultiGetItemResponse::isFailed).filter(itemResponse -> itemResponse.getFailure() != null).map(itemResponse -> itemResponse.getFailure().getId()).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            logger.info("Could not retrieve logstash pipelines with ids: {}", ids);
        }
    }

    private String toWildcardPipelineIdPattern(String wildcardPipelineId) {
        Matcher matcher = WILDCARD_PATTERN.matcher(wildcardPipelineId);
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(stringBuilder, ".*");
                continue;
            }
            matcher.appendReplacement(stringBuilder, "\\\\Q" + matcher.group(0) + "\\\\E");
        }
        matcher.appendTail(stringBuilder);
        return stringBuilder.toString();
    }
}

