/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.snapshotbasedrecoveries.recovery.plan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardRecoveryPlan;
import org.elasticsearch.indices.recovery.plan.ShardSnapshot;
import org.elasticsearch.indices.recovery.plan.ShardSnapshotsService;

public class SnapshotsRecoveryPlannerService
implements RecoveryPlannerService {
    private final Logger logger = LogManager.getLogger(SnapshotsRecoveryPlannerService.class);
    private final ShardSnapshotsService shardSnapshotsService;
    private final BooleanSupplier isLicenseActive;

    public SnapshotsRecoveryPlannerService(ShardSnapshotsService shardSnapshotsService, BooleanSupplier isLicenseActive) {
        this.shardSnapshotsService = shardSnapshotsService;
        this.isLicenseActive = isLicenseActive;
    }

    public void computeRecoveryPlan(ShardId shardId, @Nullable String shardStateIdentifier, Store.MetadataSnapshot sourceMetadata, Store.MetadataSnapshot targetMetadata, long startingSeqNo, int translogOps, Version targetVersion, boolean useSnapshots, boolean primaryRelocation, ActionListener<ShardRecoveryPlan> listener) {
        boolean canUseSnapshots = this.isLicenseActive.getAsBoolean() && useSnapshots && targetVersion.onOrAfter((VersionId)RecoverySettings.SNAPSHOT_RECOVERIES_SUPPORTED_VERSION);
        this.fetchLatestSnapshotsIgnoringErrors(shardId, canUseSnapshots, latestSnapshotOpt -> ActionListener.completeWith((ActionListener)listener, () -> this.computeRecoveryPlanWithSnapshots(shardId, shardStateIdentifier, sourceMetadata, targetMetadata, startingSeqNo, translogOps, (Optional<ShardSnapshot>)latestSnapshotOpt)));
    }

    private ShardRecoveryPlan computeRecoveryPlanWithSnapshots(ShardId shardId, @Nullable String shardStateIdentifier, Store.MetadataSnapshot sourceMetadata, Store.MetadataSnapshot targetMetadata, long startingSeqNo, int translogOps, Optional<ShardSnapshot> latestSnapshotOpt) {
        Store.RecoveryDiff sourceTargetDiff = sourceMetadata.recoveryDiff(targetMetadata);
        List filesMissingInTarget = CollectionUtils.concatLists((List)sourceTargetDiff.missing, (Collection)sourceTargetDiff.different);
        if (latestSnapshotOpt.isEmpty()) {
            this.logger.debug("{} no snapshot suitable for recovery found, falling back to recovery from the primary", (Object)shardId);
            return this.getRecoveryPlanUsingSourceNode(sourceMetadata, sourceTargetDiff, filesMissingInTarget, startingSeqNo, translogOps);
        }
        ShardSnapshot latestSnapshot = latestSnapshotOpt.get();
        if (latestSnapshot.isLogicallyEquivalent(shardStateIdentifier) && latestSnapshot.hasDifferentPhysicalFiles(sourceMetadata) && this.isSnapshotVersionCompatible(latestSnapshot) && sourceTargetDiff.identical.isEmpty()) {
            this.logger.debug(() -> org.elasticsearch.common.Strings.format((String)"%s primary has changed since snapshot completed, but snapshot still looks ok for recovery: %s", (Object[])new Object[]{shardId, latestSnapshot.getSnapshotFiles().stream().map(BlobStoreIndexShardSnapshot.FileInfo::physicalName).collect(Collectors.joining(", ", "[", "]"))}));
            ShardRecoveryPlan fallbackPlan = this.getRecoveryPlanUsingSourceNode(sourceMetadata, sourceTargetDiff, filesMissingInTarget, startingSeqNo, translogOps);
            ShardRecoveryPlan.SnapshotFilesToRecover snapshotFilesToRecover = new ShardRecoveryPlan.SnapshotFilesToRecover(latestSnapshot.getIndexId(), latestSnapshot.getRepository(), latestSnapshot.getSnapshotFiles());
            return new ShardRecoveryPlan(snapshotFilesToRecover, Collections.emptyList(), Collections.emptyList(), startingSeqNo, translogOps, latestSnapshot.getMetadataSnapshot(), fallbackPlan);
        }
        Store.MetadataSnapshot filesToRecoverFromSourceSnapshot = this.toMetadataSnapshot(filesMissingInTarget);
        Store.RecoveryDiff snapshotDiff = filesToRecoverFromSourceSnapshot.recoveryDiff(latestSnapshot.getMetadataSnapshot());
        ShardRecoveryPlan.SnapshotFilesToRecover snapshotFilesToRecover = snapshotDiff.identical.isEmpty() ? ShardRecoveryPlan.SnapshotFilesToRecover.EMPTY : new ShardRecoveryPlan.SnapshotFilesToRecover(latestSnapshot.getIndexId(), latestSnapshot.getRepository(), latestSnapshot.getSnapshotFilesMatching(snapshotDiff.identical));
        this.logger.debug(() -> org.elasticsearch.common.Strings.format((String)"%s attempting snapshot-based recovery of %s based on %s", (Object[])new Object[]{shardId, snapshotFilesToRecover.snapshotFiles().stream().map(BlobStoreIndexShardSnapshot.FileInfo::physicalName).collect(Collectors.joining(", ", "[", "]")), snapshotDiff}));
        return new ShardRecoveryPlan(snapshotFilesToRecover, CollectionUtils.concatLists((List)snapshotDiff.missing, (Collection)snapshotDiff.different), sourceTargetDiff.identical, startingSeqNo, translogOps, sourceMetadata);
    }

    private boolean isSnapshotVersionCompatible(ShardSnapshot snapshot) {
        Version commitVersion = snapshot.getCommitVersion();
        if (commitVersion == null) {
            assert (RecoverySettings.SEQ_NO_SNAPSHOT_RECOVERIES_SUPPORTED_VERSION.luceneVersion().onOrAfter(snapshot.getCommitLuceneVersion()));
            return IndexVersion.current().luceneVersion().onOrAfter(snapshot.getCommitLuceneVersion());
        }
        return commitVersion.onOrBefore((VersionId)Version.CURRENT);
    }

    private ShardRecoveryPlan getRecoveryPlanUsingSourceNode(Store.MetadataSnapshot sourceMetadata, Store.RecoveryDiff sourceTargetDiff, List<StoreFileMetadata> filesMissingInTarget, long startingSeqNo, int translogOps) {
        return new ShardRecoveryPlan(ShardRecoveryPlan.SnapshotFilesToRecover.EMPTY, filesMissingInTarget, sourceTargetDiff.identical, startingSeqNo, translogOps, sourceMetadata);
    }

    private void fetchLatestSnapshotsIgnoringErrors(final ShardId shardId, boolean useSnapshots, final Consumer<Optional<ShardSnapshot>> listener) {
        if (!useSnapshots) {
            this.logger.debug("{} recovery will not attempt to use snapshots", (Object)shardId);
            listener.accept(Optional.empty());
            return;
        }
        ActionListener<Optional<ShardSnapshot>> listenerIgnoringErrors = new ActionListener<Optional<ShardSnapshot>>(){

            public void onResponse(Optional<ShardSnapshot> shardSnapshotData) {
                listener.accept(shardSnapshotData);
            }

            public void onFailure(Exception e) {
                SnapshotsRecoveryPlannerService.this.logger.warn(() -> Strings.format((String)"Unable to fetch available snapshots for shard %s", (Object[])new Object[]{shardId}), (Throwable)e);
                listener.accept(Optional.empty());
            }
        };
        this.shardSnapshotsService.fetchLatestSnapshotsForShard(shardId, (ActionListener)listenerIgnoringErrors);
    }

    private Store.MetadataSnapshot toMetadataSnapshot(List<StoreFileMetadata> files) {
        return new Store.MetadataSnapshot(files.stream().collect(Collectors.toMap(StoreFileMetadata::name, Function.identity())), Collections.emptyMap(), 0L);
    }
}

