/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.analysis.common.UniqueTokenFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class UniqueTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean onlyOnSamePosition;

    UniqueTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name, settings);
        this.onlyOnSamePosition = settings.getAsBoolean("only_on_same_position", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new UniqueTokenFilter(tokenStream, this.onlyOnSamePosition);
    }
}

