/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankCoordinatorContext;
import org.elasticsearch.search.rank.RankShardContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.rank.rrf.RRFRankCoordinatorContext;
import org.elasticsearch.xpack.rank.rrf.RRFRankPlugin;
import org.elasticsearch.xpack.rank.rrf.RRFRankShardContext;

public class RRFRankBuilder
extends RankBuilder {
    public static final int DEFAULT_RANK_CONSTANT = 60;
    public static final ParseField RANK_CONSTANT_FIELD = new ParseField("rank_constant", new String[0]);
    static final ConstructingObjectParser<RRFRankBuilder, Void> PARSER = new ConstructingObjectParser("rrf", args -> {
        int rankConstant;
        int windowSize = args[0] == null ? 10 : (Integer)args[0];
        int n = rankConstant = args[1] == null ? 60 : (Integer)args[1];
        if (rankConstant < 1) {
            throw new IllegalArgumentException("[rank_constant] must be greater than [0] for [rrf]");
        }
        return new RRFRankBuilder(windowSize, rankConstant);
    });
    private final int rankConstant;

    public static RRFRankBuilder fromXContent(XContentParser parser) throws IOException {
        if (!RRFRankPlugin.RANK_RRF_FEATURE.check(XPackPlugin.getSharedLicenseState())) {
            throw LicenseUtils.newComplianceException((String)"Reciprocal Rank Fusion (RRF)");
        }
        return (RRFRankBuilder)((Object)PARSER.parse(parser, null));
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RANK_CONSTANT_FIELD.getPreferredName(), this.rankConstant);
    }

    public RRFRankBuilder(int windowSize, int rankConstant) {
        super(windowSize);
        this.rankConstant = rankConstant;
    }

    public RRFRankBuilder(StreamInput in) throws IOException {
        super(in);
        this.rankConstant = in.readVInt();
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.rankConstant);
    }

    public String getWriteableName() {
        return "rrf";
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_8_8_0;
    }

    public int rankConstant() {
        return this.rankConstant;
    }

    public RankShardContext buildRankShardContext(List<Query> queries, int from) {
        return new RRFRankShardContext(queries, from, this.windowSize(), this.rankConstant);
    }

    public RankCoordinatorContext buildRankCoordinatorContext(int size, int from) {
        return new RRFRankCoordinatorContext(size, from, this.windowSize(), this.rankConstant);
    }

    protected boolean doEquals(RankBuilder other) {
        return Objects.equals(this.rankConstant, ((RRFRankBuilder)other).rankConstant);
    }

    protected int doHashCode() {
        return Objects.hash(this.rankConstant);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), WINDOW_SIZE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_CONSTANT_FIELD);
    }
}

