/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tracing;

import java.util.Objects;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;

public class SpanId {
    private final String rawId;

    private SpanId(String rawId) {
        this.rawId = Objects.requireNonNull(rawId);
    }

    public String getRawId() {
        return this.rawId;
    }

    public String toString() {
        return "SpanId[" + this.rawId + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanId spanId = (SpanId)o;
        return this.rawId.equals(spanId.rawId);
    }

    public int hashCode() {
        return Objects.hash(this.rawId);
    }

    public static SpanId forTask(Task task) {
        return new SpanId("task-" + task.getId());
    }

    public static SpanId forRestRequest(RestRequest restRequest) {
        return new SpanId("rest-" + restRequest.getRequestId());
    }

    public static SpanId forBareString(String rawId) {
        return new SpanId(rawId);
    }
}

