/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.Map;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.snapshots.InternalSnapshotsInfoService;

public class SnapshotShardSizeInfo {
    public static final SnapshotShardSizeInfo EMPTY = new SnapshotShardSizeInfo(Map.of());
    private final Map<InternalSnapshotsInfoService.SnapshotShard, Long> snapshotShardSizes;

    public SnapshotShardSizeInfo(Map<InternalSnapshotsInfoService.SnapshotShard, Long> snapshotShardSizes) {
        this.snapshotShardSizes = snapshotShardSizes;
    }

    public Long getShardSize(ShardRouting shardRouting) {
        if (shardRouting.primary() && !shardRouting.active() && shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
            RecoverySource.SnapshotRecoverySource snapshotRecoverySource = (RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource();
            return this.snapshotShardSizes.get(new InternalSnapshotsInfoService.SnapshotShard(snapshotRecoverySource.snapshot(), snapshotRecoverySource.index(), shardRouting.shardId()));
        }
        assert (false) : "Expected shard with snapshot recovery source but was " + shardRouting;
        return null;
    }

    public long getShardSize(ShardRouting shardRouting, long fallback) {
        Long shardSize = this.getShardSize(shardRouting);
        if (shardSize == null || shardSize == -1L) {
            return fallback;
        }
        return shardSize;
    }
}

