/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.search.profile.AbstractProfiler;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.search.profile.query.InternalQueryProfileTree;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;

public final class QueryProfiler
extends AbstractProfiler<QueryProfileBreakdown, Query> {
    private CollectorResult collectorResult;

    public QueryProfiler() {
        super(new InternalQueryProfileTree());
    }

    public void setCollectorResult(CollectorResult collectorResult) {
        if (this.collectorResult != null) {
            throw new IllegalStateException("The collector result can only be set once.");
        }
        this.collectorResult = Objects.requireNonNull(collectorResult);
    }

    public void startRewriteTime() {
        ((InternalQueryProfileTree)this.profileTree).startRewriteTime();
    }

    public long stopAndAddRewriteTime() {
        return ((InternalQueryProfileTree)this.profileTree).stopAndAddRewriteTime();
    }

    public long getRewriteTime() {
        return ((InternalQueryProfileTree)this.profileTree).getRewriteTime();
    }

    public CollectorResult getCollectorResult() {
        return this.collectorResult;
    }
}

