/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.sandbox.search.ProfilerCollector;
import org.apache.lucene.search.Collector;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.search.query.QueryPhaseCollector;

public class InternalProfileCollector
extends ProfilerCollector {
    private final InternalProfileCollector[] children;
    private final Collector wrappedCollector;

    public InternalProfileCollector(Collector collector, String reason, InternalProfileCollector ... children) {
        super(collector, reason, Arrays.asList(children));
        this.wrappedCollector = collector;
        this.children = children;
    }

    public Collector getWrappedCollector() {
        return this.wrappedCollector;
    }

    protected String deriveCollectorName(Collector c) {
        Object s = c.getClass().getSimpleName();
        if (((String)s).equals("")) {
            s = c.getClass().getEnclosingClass().getSimpleName();
        }
        if (this.getReason().equals("aggregation") || this.getReason().equals("aggregation_global")) {
            s = (String)s + ": [" + c + "]";
        }
        return s;
    }

    public CollectorResult getCollectorTree() {
        ArrayList<CollectorResult> childResults = new ArrayList<CollectorResult>(this.children.length);
        for (InternalProfileCollector child : this.children) {
            CollectorResult result = child.getCollectorTree();
            childResults.add(result);
        }
        return new CollectorResult(this.getName(), this.getReason(), this.getTime(), childResults);
    }

    public void doPostCollection() throws IOException {
        Collector collector = this.wrappedCollector;
        if (collector instanceof InternalProfileCollector) {
            InternalProfileCollector profileCollector = (InternalProfileCollector)collector;
            profileCollector.doPostCollection();
        } else {
            collector = this.wrappedCollector;
            if (collector instanceof QueryPhaseCollector) {
                QueryPhaseCollector queryPhaseCollector = (QueryPhaseCollector)collector;
                queryPhaseCollector.doPostCollection();
            } else {
                collector = this.wrappedCollector;
                if (collector instanceof BucketCollector.BucketCollectorWrapper) {
                    BucketCollector.BucketCollectorWrapper aggsCollector = (BucketCollector.BucketCollectorWrapper)collector;
                    aggsCollector.bucketCollector().postCollection();
                }
            }
        }
    }
}

