/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.lookup.FieldLookup;
import org.elasticsearch.search.lookup.LeafFieldLookupProvider;

class PreloadedFieldLookupProvider
implements LeafFieldLookupProvider {
    Map<String, List<Object>> storedFields;
    LeafFieldLookupProvider backUpLoader;
    Supplier<LeafFieldLookupProvider> loaderSupplier;

    PreloadedFieldLookupProvider() {
    }

    @Override
    public void populateFieldLookup(FieldLookup fieldLookup, int doc) throws IOException {
        String field = fieldLookup.fieldType().name();
        if (this.storedFields.containsKey(field)) {
            fieldLookup.setValues(this.storedFields.get(field));
            return;
        }
        if (this.backUpLoader == null) {
            this.backUpLoader = this.loaderSupplier.get();
        }
        this.backUpLoader.populateFieldLookup(fieldLookup, doc);
    }

    void setNextReader(LeafReaderContext ctx) {
        this.backUpLoader = null;
        this.loaderSupplier = () -> LeafFieldLookupProvider.fromStoredFields().apply(ctx);
    }
}

