/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.profile.ProfileResult;

public final class FetchSearchResult
extends SearchPhaseResult {
    private SearchHits hits;
    private transient int counter;
    private ProfileResult profileResult;

    public FetchSearchResult() {
    }

    public FetchSearchResult(ShardSearchContextId id, SearchShardTarget shardTarget) {
        this.contextId = id;
        this.setSearchShardTarget(shardTarget);
    }

    public FetchSearchResult(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.hits = new SearchHits(in);
        this.profileResult = in.getTransportVersion().onOrAfter(TransportVersion.V_7_16_0) ? in.readOptionalWriteable(ProfileResult::new) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.contextId.writeTo(out);
        this.hits.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_16_0)) {
            out.writeOptionalWriteable(this.profileResult);
        }
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this;
    }

    public void shardResult(SearchHits hits, ProfileResult profileResult) {
        assert (FetchSearchResult.assertNoSearchTarget(hits));
        this.hits = hits;
        assert (this.profileResult == null);
        this.profileResult = profileResult;
    }

    private static boolean assertNoSearchTarget(SearchHits hits) {
        for (SearchHit hit : hits.getHits()) {
            assert (hit.getShard() == null) : "expected null but got: " + hit.getShard();
        }
        return true;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public FetchSearchResult initCounter() {
        this.counter = 0;
        return this;
    }

    public int counterGetAndIncrement() {
        return this.counter++;
    }

    public ProfileResult profileResult() {
        return this.profileResult;
    }
}

