/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.hppc.BitMixer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.RegExp;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class IncludeExclude
implements Writeable,
ToXContentFragment {
    public static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    public static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    public static final ParseField PARTITION_FIELD = new ParseField("partition", new String[0]);
    public static final ParseField NUM_PARTITIONS_FIELD = new ParseField("num_partitions", new String[0]);
    private static final int HASH_PARTITIONING_SEED = 31;
    private final RegExp include;
    private final RegExp exclude;
    private final SortedSet<BytesRef> includeValues;
    private final SortedSet<BytesRef> excludeValues;
    private final int incZeroBasedPartition;
    private final int incNumPartitions;

    public static IncludeExclude merge(IncludeExclude include, IncludeExclude exclude) {
        if (include == null) {
            return exclude;
        }
        if (exclude == null) {
            return include;
        }
        if (include.isPartitionBased()) {
            throw new IllegalArgumentException("Cannot specify any excludes when using a partition-based include");
        }
        return new IncludeExclude(include.include == null ? null : include.include.getOriginalString(), exclude.exclude == null ? null : exclude.exclude.getOriginalString(), include.includeValues, exclude.excludeValues);
    }

    public static IncludeExclude parseInclude(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new IncludeExclude(parser.text(), null, null, null);
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return new IncludeExclude(null, null, new TreeSet<BytesRef>(IncludeExclude.parseArrayToSet(parser)), null);
        }
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            Integer partition = null;
            Integer numPartitions = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (NUM_PARTITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    numPartitions = parser.intValue();
                    continue;
                }
                if (PARTITION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    partition = parser.intValue();
                    continue;
                }
                throw new ElasticsearchParseException("Unknown parameter in Include/Exclude clause: " + currentFieldName, new Object[0]);
            }
            if (partition == null) {
                throw new IllegalArgumentException("Missing [" + PARTITION_FIELD.getPreferredName() + "] parameter for partition-based include");
            }
            if (numPartitions == null) {
                throw new IllegalArgumentException("Missing [" + NUM_PARTITIONS_FIELD.getPreferredName() + "] parameter for partition-based include");
            }
            return new IncludeExclude(partition, numPartitions);
        }
        throw new IllegalArgumentException("Unrecognized token for an include [" + token + "]");
    }

    public static IncludeExclude parseExclude(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new IncludeExclude(null, parser.text(), null, null);
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return new IncludeExclude(null, null, null, new TreeSet<BytesRef>(IncludeExclude.parseArrayToSet(parser)));
        }
        throw new IllegalArgumentException("Unrecognized token for an exclude [" + token + "]");
    }

    public IncludeExclude(@Nullable String include, @Nullable String exclude, @Nullable SortedSet<BytesRef> includeValues, @Nullable SortedSet<BytesRef> excludeValues) {
        if (include == null && exclude == null && includeValues == null && excludeValues == null) {
            throw new IllegalArgumentException();
        }
        if (include != null && includeValues != null) {
            throw new IllegalArgumentException();
        }
        if (exclude != null && excludeValues != null) {
            throw new IllegalArgumentException();
        }
        this.include = include == null ? null : new RegExp(include);
        this.exclude = exclude == null ? null : new RegExp(exclude);
        this.includeValues = includeValues;
        this.excludeValues = excludeValues;
        this.incZeroBasedPartition = 0;
        this.incNumPartitions = 0;
    }

    public IncludeExclude(int partition, int numPartitions) {
        if (partition < 0 || partition >= numPartitions) {
            throw new IllegalArgumentException("Partition must be >=0 and < numPartition which is " + numPartitions);
        }
        this.incZeroBasedPartition = partition;
        this.incNumPartitions = numPartitions;
        this.include = null;
        this.exclude = null;
        this.includeValues = null;
        this.excludeValues = null;
    }

    public IncludeExclude(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            String includeString = in.readOptionalString();
            this.include = includeString == null ? null : new RegExp(includeString);
            String excludeString = in.readOptionalString();
            RegExp regExp = this.exclude = excludeString == null ? null : new RegExp(excludeString);
            if (in.getTransportVersion().before(TransportVersion.V_7_11_0)) {
                this.incZeroBasedPartition = 0;
                this.incNumPartitions = 0;
                this.includeValues = null;
                this.excludeValues = null;
                return;
            }
        } else {
            this.include = null;
            this.exclude = null;
        }
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.includeValues = new TreeSet<BytesRef>();
            for (int i = 0; i < size; ++i) {
                this.includeValues.add(in.readBytesRef());
            }
        } else {
            this.includeValues = null;
        }
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.excludeValues = new TreeSet<BytesRef>();
            for (int i = 0; i < size; ++i) {
                this.excludeValues.add(in.readBytesRef());
            }
        } else {
            this.excludeValues = null;
        }
        this.incNumPartitions = in.readVInt();
        this.incZeroBasedPartition = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean regexBased = this.isRegexBased();
        out.writeBoolean(regexBased);
        if (regexBased) {
            out.writeOptionalString(this.include == null ? null : this.include.getOriginalString());
            out.writeOptionalString(this.exclude == null ? null : this.exclude.getOriginalString());
            if (out.getTransportVersion().before(TransportVersion.V_7_11_0)) {
                return;
            }
        }
        boolean hasIncludes = this.includeValues != null;
        out.writeBoolean(hasIncludes);
        if (hasIncludes) {
            out.writeCollection(this.includeValues, StreamOutput::writeBytesRef);
        }
        boolean hasExcludes = this.excludeValues != null;
        out.writeBoolean(hasExcludes);
        if (hasExcludes) {
            out.writeCollection(this.excludeValues, StreamOutput::writeBytesRef);
        }
        out.writeVInt(this.incNumPartitions);
        out.writeVInt(this.incZeroBasedPartition);
    }

    private static Set<BytesRef> parseArrayToSet(XContentParser parser) throws IOException {
        HashSet<BytesRef> set = new HashSet<BytesRef>();
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("Missing start of array in include/exclude clause", new Object[0]);
        }
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (!parser.currentToken().isValue()) {
                throw new ElasticsearchParseException("Array elements in include/exclude clauses should be string values", new Object[0]);
            }
            set.add(new BytesRef((CharSequence)parser.text()));
        }
        return set;
    }

    public boolean isRegexBased() {
        return this.include != null || this.exclude != null;
    }

    public boolean isPartitionBased() {
        return this.incNumPartitions > 0;
    }

    private Automaton toAutomaton() {
        Automaton a = null;
        if (this.include == null && this.exclude == null) {
            return a;
        }
        a = this.include != null ? this.include.toAutomaton() : Automata.makeAnyString();
        if (this.exclude != null) {
            a = Operations.minus((Automaton)a, (Automaton)this.exclude.toAutomaton(), (int)10000);
        }
        return a;
    }

    public StringFilter convertToStringFilter(DocValueFormat format) {
        if (this.isPartitionBased()) {
            return new PartitionedStringFilter();
        }
        return new SetAndRegexStringFilter(format);
    }

    private static SortedSet<BytesRef> parseForDocValues(SortedSet<BytesRef> endUserFormattedValues, DocValueFormat format) {
        SortedSet<BytesRef> result = endUserFormattedValues;
        if (endUserFormattedValues != null && format != DocValueFormat.RAW) {
            result = new TreeSet<BytesRef>();
            for (BytesRef formattedVal : endUserFormattedValues) {
                result.add(format.parseBytesRef(formattedVal.utf8ToString()));
            }
        }
        return result;
    }

    public OrdinalsFilter convertToOrdinalsFilter(DocValueFormat format) {
        if (this.isPartitionBased()) {
            return new PartitionedOrdinalsFilter();
        }
        return new SetAndRegexOrdinalsFilter(format);
    }

    public LongFilter convertToLongFilter(DocValueFormat format) {
        if (this.isPartitionBased()) {
            return new PartitionedLongFilter();
        }
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        SetBackedLongFilter result = new SetBackedLongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                result.addAccept(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                result.addReject(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        return result;
    }

    public LongFilter convertToDoubleFilter() {
        double dval;
        if (this.isPartitionBased()) {
            return new PartitionedLongFilter();
        }
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        SetBackedLongFilter result = new SetBackedLongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addAccept(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addReject(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include != null) {
            builder.field(INCLUDE_FIELD.getPreferredName(), this.include.getOriginalString());
        } else if (this.includeValues != null) {
            builder.startArray(INCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.includeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        } else if (this.isPartitionBased()) {
            builder.startObject(INCLUDE_FIELD.getPreferredName());
            builder.field(PARTITION_FIELD.getPreferredName(), this.incZeroBasedPartition);
            builder.field(NUM_PARTITIONS_FIELD.getPreferredName(), this.incNumPartitions);
            builder.endObject();
        }
        if (this.exclude != null) {
            builder.field(EXCLUDE_FIELD.getPreferredName(), this.exclude.getOriginalString());
        } else if (this.excludeValues != null) {
            builder.startArray(EXCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.excludeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.include == null ? null : this.include.getOriginalString(), this.exclude == null ? null : this.exclude.getOriginalString(), this.includeValues, this.excludeValues, this.incZeroBasedPartition, this.incNumPartitions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeExclude other = (IncludeExclude)obj;
        return Objects.equals(this.include == null ? null : this.include.getOriginalString(), other.include == null ? null : other.include.getOriginalString()) && Objects.equals(this.exclude == null ? null : this.exclude.getOriginalString(), other.exclude == null ? null : other.exclude.getOriginalString()) && Objects.equals(this.includeValues, other.includeValues) && Objects.equals(this.excludeValues, other.excludeValues) && Objects.equals(this.incZeroBasedPartition, other.incZeroBasedPartition) && Objects.equals(this.incNumPartitions, other.incNumPartitions);
    }

    class PartitionedStringFilter
    extends StringFilter {
        PartitionedStringFilter() {
        }

        @Override
        public boolean accept(BytesRef value) {
            return Math.floorMod(StringHelper.murmurhash3_x86_32((BytesRef)value, (int)31), IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition;
        }
    }

    class SetAndRegexStringFilter
    extends StringFilter {
        private final ByteRunAutomaton runAutomaton;
        private final Set<BytesRef> valids;
        private final Set<BytesRef> invalids;

        private SetAndRegexStringFilter(DocValueFormat format) {
            Automaton automaton = IncludeExclude.this.toAutomaton();
            this.runAutomaton = automaton == null ? null : new ByteRunAutomaton(automaton);
            this.valids = IncludeExclude.parseForDocValues(IncludeExclude.this.includeValues, format);
            this.invalids = IncludeExclude.parseForDocValues(IncludeExclude.this.excludeValues, format);
        }

        @Override
        public boolean accept(BytesRef value) {
            if (this.valids != null && !this.valids.contains(value)) {
                return false;
            }
            if (this.runAutomaton != null && !this.runAutomaton.run(value.bytes, value.offset, value.length)) {
                return false;
            }
            return this.invalids == null || !this.invalids.contains(value);
        }
    }

    class PartitionedOrdinalsFilter
    extends OrdinalsFilter {
        PartitionedOrdinalsFilter() {
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            long numOrds = globalOrdinals.getValueCount();
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(numOrds);
            TermsEnum termEnum = globalOrdinals.termsEnum();
            BytesRef term = termEnum.next();
            while (term != null) {
                if (Math.floorMod(StringHelper.murmurhash3_x86_32((BytesRef)term, (int)31), IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition) {
                    acceptedGlobalOrdinals.set(termEnum.ord());
                }
                term = termEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    class SetAndRegexOrdinalsFilter
    extends OrdinalsFilter {
        private final CompiledAutomaton compiled;
        private final SortedSet<BytesRef> valids;
        private final SortedSet<BytesRef> invalids;

        private SetAndRegexOrdinalsFilter(DocValueFormat format) {
            Automaton automaton = IncludeExclude.this.toAutomaton();
            this.compiled = automaton == null ? null : new CompiledAutomaton(automaton);
            this.valids = IncludeExclude.parseForDocValues(IncludeExclude.this.includeValues, format);
            this.invalids = IncludeExclude.parseForDocValues(IncludeExclude.this.excludeValues, format);
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            LongBitSet acceptedGlobalOrdinals = null;
            if (this.valids != null) {
                acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
                for (BytesRef term : this.valids) {
                    long ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.set(ord);
                }
            }
            if (this.compiled != null) {
                LongBitSet automatonGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
                DocValuesTerms globalTerms = new DocValuesTerms(globalOrdinals);
                TermsEnum globalTermsEnum = this.compiled.getTermsEnum((Terms)globalTerms);
                BytesRef term = globalTermsEnum.next();
                while (term != null) {
                    automatonGlobalOrdinals.set(globalTermsEnum.ord());
                    term = globalTermsEnum.next();
                }
                if (acceptedGlobalOrdinals == null) {
                    acceptedGlobalOrdinals = automatonGlobalOrdinals;
                } else {
                    acceptedGlobalOrdinals.and(automatonGlobalOrdinals);
                }
            }
            if (acceptedGlobalOrdinals == null && (acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount())).length() > 0L) {
                acceptedGlobalOrdinals.set(0L, acceptedGlobalOrdinals.length());
            }
            if (this.invalids != null) {
                for (BytesRef term : this.invalids) {
                    long ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.clear(ord);
                }
            }
            return acceptedGlobalOrdinals;
        }
    }

    public class PartitionedLongFilter
    extends LongFilter {
        @Override
        public boolean accept(long value) {
            long hashCode = BitMixer.mix64((long)value);
            return Math.floorMod(hashCode, IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition;
        }
    }

    public static class SetBackedLongFilter
    extends LongFilter {
        private Set<Long> valids;
        private Set<Long> invalids;
        private Long spare = new Long(0L);

        private SetBackedLongFilter(int numValids, int numInvalids) {
            if (numValids > 0) {
                this.valids = Sets.newHashSetWithExpectedSize(numValids);
            }
            if (numInvalids > 0) {
                this.invalids = Sets.newHashSetWithExpectedSize(numInvalids);
            }
        }

        @Override
        public boolean accept(long value) {
            this.spare.value = value;
            return !(this.valids != null && !this.valids.contains(this.spare) || this.invalids != null && this.invalids.contains(this.spare));
        }

        private void addAccept(long val) {
            this.valids.add(new Long(val));
        }

        private void addReject(long val) {
            this.invalids.add(new Long(val));
        }

        private static class Long {
            private long value;

            private Long(long value) {
                this.value = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Long that = (Long)o;
                return this.value == that.value;
            }

            public int hashCode() {
                return java.lang.Long.hashCode(this.value);
            }
        }
    }

    private static class DocValuesTerms
    extends Terms {
        private final SortedSetDocValues values;

        DocValuesTerms(SortedSetDocValues values) {
            this.values = values;
        }

        public TermsEnum iterator() throws IOException {
            return this.values.termsEnum();
        }

        public long size() throws IOException {
            return -1L;
        }

        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        public long getSumDocFreq() throws IOException {
            return -1L;
        }

        public int getDocCount() throws IOException {
            return -1;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    }

    public static abstract class OrdinalsFilter
    extends Filter {
        public abstract LongBitSet acceptedGlobalOrdinals(SortedSetDocValues var1) throws IOException;
    }

    public static abstract class StringFilter
    extends Filter {
        public abstract boolean accept(BytesRef var1);
    }

    public static abstract class LongFilter
    extends Filter {
        public abstract boolean accept(long var1);
    }

    public static abstract class Filter {
    }
}

