/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AdaptingAggregator;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FilterAggregationBuilder
extends AbstractAggregationBuilder<FilterAggregationBuilder> {
    public static final String NAME = "filter";
    private final QueryBuilder filter;

    public FilterAggregationBuilder(String name, QueryBuilder filter) {
        super(name);
        if (filter == null) {
            throw new IllegalArgumentException("[filter] must not be null: [" + name + "]");
        }
        this.filter = filter;
    }

    protected FilterAggregationBuilder(FilterAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.filter = clone.filter;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new FilterAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public FilterAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.filter = in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    public boolean supportsSampling() {
        return true;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.filter);
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    @Override
    protected AggregationBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder result = Rewriteable.rewrite(this.filter, queryRewriteContext);
        if (result != this.filter) {
            return new FilterAggregationBuilder(this.getName(), result);
        }
        return this;
    }

    @Override
    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new FilterAggregatorFactory(this.filter, this.name, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter != null) {
            this.filter.toXContent(builder, params);
        }
        return builder;
    }

    public static FilterAggregationBuilder parse(XContentParser parser, String aggregationName) throws IOException {
        QueryBuilder filter = AbstractQueryBuilder.parseTopLevelQuery(parser);
        return new FilterAggregationBuilder(aggregationName, filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filter);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FilterAggregationBuilder other = (FilterAggregationBuilder)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public String getType() {
        return NAME;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.ZERO;
    }

    public static class FilterAggregatorFactory
    extends AggregatorFactory {
        private final QueryToFilterAdapter filter;

        public FilterAggregatorFactory(QueryBuilder filter, String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, subFactoriesBuilder, metadata);
            this.filter = QueryToFilterAdapter.build(context.searcher(), "1", context.buildQuery(filter));
        }

        @Override
        protected Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            FiltersAggregator innerAggregator = FiltersAggregator.build(this.name, this.factories, List.of(this.filter), false, null, true, this.context, parent, cardinality, metadata);
            return new FilterAggregator(this.name, parent, this.factories, innerAggregator);
        }
    }

    static class FilterAggregator
    extends AdaptingAggregator
    implements SingleBucketAggregator {
        private final String name;
        private final FiltersAggregator innerAggregator;

        FilterAggregator(String name, Aggregator parent, AggregatorFactories subAggregators, FiltersAggregator innerAggregator) throws IOException {
            super(parent, subAggregators, (CheckedFunction<AggregatorFactories, ? extends Aggregator, IOException>)((CheckedFunction)aggregatorFactories -> innerAggregator));
            this.name = name;
            this.innerAggregator = innerAggregator;
        }

        @Override
        protected InternalAggregation adapt(InternalAggregation delegateResult) throws IOException {
            InternalFilters innerResult = (InternalFilters)delegateResult;
            InternalFilters.InternalBucket innerBucket = innerResult.getBuckets().get(0);
            return new InternalFilter(this.name, innerBucket.getDocCount(), innerBucket.getAggregations(), innerResult.getMetadata());
        }

        @Override
        public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
            return this.resolveSortPathOnValidAgg(next, path);
        }

        @Override
        public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key == null || "doc_count".equals(key)) {
                return (lhs, rhs) -> order.reverseMul() * Long.compare(this.innerAggregator.bucketDocCount(lhs), this.innerAggregator.bucketDocCount(rhs));
            }
            return super.bucketComparator(key, order);
        }
    }
}

