/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class GlobalOrdinalValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private static final Logger logger = LogManager.getLogger(GlobalOrdinalValuesSource.class);
    public static final int MAX_TERMS_FOR_DYNAMIC_PRUNING = 128;
    public static final long MISSING_VALUE_FLAG = -1L;
    private final long uniqueValueCount;
    private final CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc;
    private LongArray values;
    private SortedSetDocValues lookup;
    private long currentValue;
    private Long afterValueGlobalOrd;
    private Long highestCompetitiveValueGlobalOrd;
    private boolean isTopValueInsertionPoint;
    private CompetitiveIterator currentCompetitiveIterator;
    private int segmentsDynamicPruningUsed;
    private int totalSegments;
    private long lastLookupOrd = -1L;
    private BytesRef lastLookupValue;

    GlobalOrdinalValuesSource(BigArrays bigArrays, MappedFieldType type, long uniqueValueCount, CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, type, missingBucket, missingOrder, size, reverseMul);
        this.uniqueValueCount = uniqueValueCount;
        this.docValuesFunc = docValuesFunc;
        this.values = bigArrays.newLongArray(Math.min(size, 100), false);
    }

    long getUniqueValueCount() {
        return this.uniqueValueCount;
    }

    boolean mayDynamicallyPrune(IndexReader indexReader) {
        if (this.missingBucket) {
            return false;
        }
        if (this.fieldType == null || !this.fieldType.isIndexed() || !this.fieldType.hasDocValues()) {
            return false;
        }
        return this.hasTerms(indexReader);
    }

    private boolean hasTerms(IndexReader indexReader) {
        assert (this.fieldType != null);
        List leaves = indexReader.leaves();
        for (LeafReaderContext leaf : leaves) {
            Terms terms;
            try {
                terms = leaf.reader().terms(this.fieldType.name());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (terms == null) continue;
            return true;
        }
        return false;
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        this.values.set(slot, this.currentValue);
    }

    private int compareInternal(long lhs, long rhs) {
        int mul = lhs == -1L || rhs == -1L ? this.missingOrder.compareAnyValueToMissing(this.reverseMul) : this.reverseMul;
        return Long.compare(lhs, rhs) * mul;
    }

    @Override
    int compare(int from, int to) {
        return this.compareInternal(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        return this.compareInternal(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        int cmp = this.compareInternal(this.currentValue, this.afterValueGlobalOrd);
        if (cmp == 0 && this.isTopValueInsertionPoint) {
            return this.missingOrder.compareAnyValueToMissing(this.reverseMul);
        }
        return cmp;
    }

    @Override
    int hashCode(int slot) {
        return Long.hashCode(this.values.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        return Long.hashCode(this.currentValue);
    }

    @Override
    void setAfter(Comparable<?> value) {
        if (this.missingBucket && value == null) {
            this.afterValue = null;
            this.afterValueGlobalOrd = -1L;
        } else if (value.getClass() == String.class || this.fieldType == null) {
            this.afterValue = this.format.parseBytesRef(value);
        } else if (value.getClass() == BytesRef.class) {
            this.afterValue = (BytesRef)value;
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
    }

    @Override
    BytesRef toComparable(int slot) throws IOException {
        long globalOrd = this.values.get(slot);
        if (this.missingBucket && globalOrd == -1L) {
            return null;
        }
        if (globalOrd == this.lastLookupOrd) {
            return this.lastLookupValue;
        }
        this.lastLookupOrd = globalOrd;
        this.lastLookupValue = BytesRef.deepCopyOf((BytesRef)this.lookup.lookupOrd(this.values.get(slot)));
        return this.lastLookupValue;
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        CompetitiveIterator competitiveIterator;
        ++this.totalSegments;
        final SortedSetDocValues dvs = (SortedSetDocValues)this.docValuesFunc.apply((Object)context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        this.currentCompetitiveIterator = competitiveIterator = this.fieldType == null ? null : new CompetitiveIterator(context, this.fieldType.name());
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        next.collect(doc, bucket);
                    }
                } else if (GlobalOrdinalValuesSource.this.missingBucket) {
                    GlobalOrdinalValuesSource.this.currentValue = -1L;
                    next.collect(doc, bucket);
                }
            }

            public DocIdSetIterator competitiveIterator() {
                return competitiveIterator;
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<BytesRef> value, LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        ++this.totalSegments;
        final BytesRef term = (BytesRef)value;
        final SortedSetDocValues dvs = (SortedSetDocValues)this.docValuesFunc.apply((Object)context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){
            boolean currentValueIsSet = false;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (!this.currentValueIsSet && dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        if (!term.equals((Object)GlobalOrdinalValuesSource.this.lookup.lookupOrd(ord))) continue;
                        this.currentValueIsSet = true;
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        break;
                    }
                }
                assert (this.currentValueIsSet);
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    public void close() {
        Releasables.close((Releasable)this.values);
    }

    private void initLookup(SortedSetDocValues dvs) throws IOException {
        this.lookup = dvs;
        if (this.afterValue != null && this.afterValueGlobalOrd == null) {
            this.afterValueGlobalOrd = this.lookup.lookupTerm((BytesRef)this.afterValue);
            if (this.afterValueGlobalOrd < 0L) {
                this.afterValueGlobalOrd = -this.afterValueGlobalOrd.longValue() - 1L;
                this.isTopValueInsertionPoint = true;
            }
        }
    }

    public void updateHighestCompetitiveValue(int slot) throws IOException {
        this.highestCompetitiveValueGlobalOrd = this.values.get(slot);
        logger.trace("Highest observed set to [{}]", new Object[]{this.highestCompetitiveValueGlobalOrd});
        CompetitiveIterator competitiveIterator = this.currentCompetitiveIterator;
        if (competitiveIterator != null) {
            competitiveIterator.updateBounds();
        }
    }

    void collectDebugInfo(String namespace, BiConsumer<String, Object> add) {
        add.accept(Strings.format((String)"%s.segments_collected", (Object[])new Object[]{namespace}), this.totalSegments);
        add.accept(Strings.format((String)"%s.segments_dynamic_pruning_used", (Object[])new Object[]{namespace}), this.segmentsDynamicPruningUsed);
    }

    private class CompetitiveIterator
    extends DocIdSetIterator {
        private final LeafReaderContext context;
        private final int maxDoc;
        private final String field;
        private int doc = -1;
        private ArrayDeque<PostingsEnumAndOrd> postings;
        private DocIdSetIterator docsWithField;
        private PriorityQueue<PostingsEnumAndOrd> disjunction;

        CompetitiveIterator(LeafReaderContext context, String field) {
            this.context = context;
            this.maxDoc = context.reader().maxDoc();
            this.field = field;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.docID() + 1);
        }

        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.disjunction == null) {
                if (this.docsWithField != null) {
                    this.doc = this.docsWithField.advance(target);
                    return this.doc;
                }
                this.doc = target;
                return this.doc;
            }
            PostingsEnumAndOrd top = (PostingsEnumAndOrd)this.disjunction.top();
            if (top == null) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            while (top.postings.docID() < target) {
                top.postings.advance(target);
                top = (PostingsEnumAndOrd)this.disjunction.updateTop();
            }
            this.doc = top.postings.docID();
            return this.doc;
        }

        public long cost() {
            return this.context.reader().maxDoc();
        }

        private void update(long minOrd, long maxOrd) throws IOException {
            int maxTerms = Math.min(128, IndexSearcher.getMaxClauseCount());
            long size = Math.max(0L, maxOrd - minOrd + 1L);
            if (size > (long)maxTerms) {
                if (this.docsWithField == null) {
                    this.docsWithField = (DocIdSetIterator)GlobalOrdinalValuesSource.this.docValuesFunc.apply((Object)this.context);
                }
            } else if (this.postings == null) {
                this.init(minOrd, maxOrd);
            } else {
                boolean removed = false;
                while (!this.postings.isEmpty() && this.postings.getFirst().ord < minOrd) {
                    removed = true;
                    this.postings.removeFirst();
                }
                while (!this.postings.isEmpty() && this.postings.getLast().ord > maxOrd) {
                    removed = true;
                    this.postings.removeLast();
                }
                if (removed) {
                    this.disjunction.clear();
                    this.disjunction.addAll(this.postings);
                }
            }
        }

        private void init(long minOrd, long maxOrd) throws IOException {
            Terms terms;
            ++GlobalOrdinalValuesSource.this.segmentsDynamicPruningUsed;
            int size = (int)Math.max(0L, maxOrd - minOrd + 1L);
            this.postings = new ArrayDeque(size);
            if (size > 0 && (terms = this.context.reader().terms(this.field)) != null) {
                BytesRef minTerm = BytesRef.deepCopyOf((BytesRef)GlobalOrdinalValuesSource.this.lookup.lookupOrd(minOrd));
                TermsEnum termsEnum = terms.iterator();
                TermsEnum.SeekStatus seekStatus = termsEnum.seekCeil(minTerm);
                if (seekStatus != TermsEnum.SeekStatus.END) {
                    BytesRef maxTerm = BytesRef.deepCopyOf((BytesRef)GlobalOrdinalValuesSource.this.lookup.lookupOrd(maxOrd));
                    TermsEnum globalTermsEnum = GlobalOrdinalValuesSource.this.lookup.termsEnum();
                    globalTermsEnum.seekExact(minOrd);
                    BytesRef term = termsEnum.term();
                    while (term != null && term.compareTo(maxTerm) <= 0) {
                        while (globalTermsEnum.term().compareTo(term) < 0) {
                            BytesRef nextGlobalTerm = globalTermsEnum.next();
                            assert (nextGlobalTerm != null);
                        }
                        assert (globalTermsEnum.term().equals((Object)term));
                        long globalOrd = globalTermsEnum.ord();
                        this.postings.add(new PostingsEnumAndOrd(termsEnum.postings(null, 0), globalOrd));
                        term = termsEnum.next();
                    }
                }
            }
            this.disjunction = new PriorityQueue<PostingsEnumAndOrd>(size){

                protected boolean lessThan(PostingsEnumAndOrd a, PostingsEnumAndOrd b) {
                    return a.postings.docID() < b.postings.docID();
                }
            };
            this.disjunction.addAll(this.postings);
        }

        public void updateBounds() throws IOException {
            if (GlobalOrdinalValuesSource.this.highestCompetitiveValueGlobalOrd == null) {
                return;
            }
            long lowOrd = GlobalOrdinalValuesSource.this.afterValueGlobalOrd != null && GlobalOrdinalValuesSource.this.afterValueGlobalOrd != -1L ? GlobalOrdinalValuesSource.this.afterValueGlobalOrd : (GlobalOrdinalValuesSource.this.reverseMul == 1 ? 0L : GlobalOrdinalValuesSource.this.lookup.getValueCount() - 1L);
            this.update(Math.min(GlobalOrdinalValuesSource.this.highestCompetitiveValueGlobalOrd, lowOrd), Math.max(GlobalOrdinalValuesSource.this.highestCompetitiveValueGlobalOrd, lowOrd));
        }
    }

    private record PostingsEnumAndOrd(PostingsEnum postings, long ord) {
    }
}

