/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;

public class SearchContextAggregations {
    private final AggregatorFactories factories;
    private final Supplier<AggregationReduceContext.Builder> toAggregationReduceContextBuilder;
    private final List<Aggregator[]> aggregators;
    private CollectorManager<Collector, Void> aggCollectorManager;

    public SearchContextAggregations(AggregatorFactories factories, Supplier<AggregationReduceContext.Builder> toAggregationReduceContextBuilder) {
        this.factories = factories;
        this.toAggregationReduceContextBuilder = toAggregationReduceContextBuilder;
        this.aggregators = new ArrayList<Aggregator[]>();
    }

    public AggregatorFactories factories() {
        return this.factories;
    }

    public List<Aggregator[]> aggregators() {
        return this.aggregators;
    }

    public void aggregators(Aggregator[] aggregators) {
        this.aggregators.add(aggregators);
    }

    public void registerAggsCollectorManager(CollectorManager<Collector, Void> aggCollectorManager) {
        this.aggCollectorManager = aggCollectorManager;
    }

    public CollectorManager<Collector, Void> getAggsCollectorManager() {
        return this.aggCollectorManager;
    }

    public boolean isInSortOrderExecutionRequired() {
        return this.factories.context() != null && this.factories.context().isInSortOrderExecutionRequired();
    }

    public AggregationReduceContext.Builder getAggregationReduceContextBuilder() {
        return this.toAggregationReduceContextBuilder.get();
    }
}

