/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class AggregationBuilder
implements VersionedNamedWriteable,
ToXContentFragment,
BaseAggregationBuilder,
Rewriteable<AggregationBuilder> {
    public static final long DEFAULT_PREALLOCATION = 6144L;
    protected final String name;
    protected AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder();

    protected AggregationBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        this.name = name;
    }

    protected AggregationBuilder(AggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder) {
        this.name = clone.name;
        this.factoriesBuilder = factoriesBuilder;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Set<String>> getOutputFieldNames() {
        return Optional.empty();
    }

    protected abstract AggregatorFactory build(AggregationContext var1, AggregatorFactory var2) throws IOException;

    @Override
    public abstract AggregationBuilder setMetadata(Map<String, Object> var1);

    public abstract Map<String, Object> getMetadata();

    public abstract AggregationBuilder subAggregation(AggregationBuilder var1);

    public abstract AggregationBuilder subAggregation(PipelineAggregationBuilder var1);

    public Collection<AggregationBuilder> getSubAggregations() {
        return this.factoriesBuilder.getAggregatorFactories();
    }

    public Collection<PipelineAggregationBuilder> getPipelineAggregations() {
        return this.factoriesBuilder.getPipelineAggregatorFactories();
    }

    @Override
    public abstract AggregationBuilder subAggregations(AggregatorFactories.Builder var1);

    protected abstract AggregationBuilder shallowCopy(AggregatorFactories.Builder var1, Map<String, Object> var2);

    @Override
    public final AggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        AggregationBuilder rewritten = this.doRewrite(context);
        AggregatorFactories.Builder rewrittenSubAggs = this.factoriesBuilder.rewrite(context);
        if (rewritten != this) {
            return this.getMetadata() == null ? rewritten.subAggregations(rewrittenSubAggs) : ((AggregationBuilder)rewritten.setMetadata((Map)this.getMetadata())).subAggregations(rewrittenSubAggs);
        }
        if (rewrittenSubAggs != this.factoriesBuilder) {
            return this.shallowCopy(rewrittenSubAggs, this.getMetadata());
        }
        return this;
    }

    protected AggregationBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return this;
    }

    public PipelineAggregator.PipelineTree buildPipelineTree() {
        return this.factoriesBuilder.buildPipelineTree();
    }

    public abstract BucketCardinality bucketCardinality();

    public long bytesToPreallocate() {
        return 6144L;
    }

    public boolean supportsSampling() {
        return false;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean isInSortOrderExecutionRequired() {
        for (AggregationBuilder builder : this.factoriesBuilder.getAggregatorFactories()) {
            if (!builder.isInSortOrderExecutionRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean supportsParallelCollection() {
        if (this.isInSortOrderExecutionRequired()) {
            return false;
        }
        for (AggregationBuilder builder : this.factoriesBuilder.getAggregatorFactories()) {
            if (builder.supportsParallelCollection()) continue;
            return false;
        }
        return true;
    }

    protected void validateSequentiallyOrdered(String type, String name, Consumer<String> addValidationError) {
        addValidationError.accept(type + " aggregation [" + name + "] must have a histogram, date_histogram or auto_date_histogram as parent");
    }

    protected void validateSequentiallyOrderedWithoutGaps(String type, String name, Consumer<String> addValidationError) {
        this.validateSequentiallyOrdered(type, name, addValidationError);
    }

    public static final class CommonFields
    extends ParseField.CommonFields {
        public static final ParseField VALUE_TYPE = new ParseField("value_type", new String[0]);
    }

    public static enum BucketCardinality {
        NONE,
        ONE,
        MANY;

    }
}

