/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class IPAddress
implements ToXContentObject {
    protected final InetAddress address;

    IPAddress(InetAddress address) {
        this.address = address;
    }

    public IPAddress(String address) {
        this.address = InetAddresses.forString(address);
    }

    public boolean isV4() {
        return this.address instanceof Inet4Address;
    }

    public boolean isV6() {
        return this.address instanceof Inet6Address;
    }

    public String toString() {
        return InetAddresses.toAddrString(this.address);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }
}

