/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class TimeSeries
implements Writeable,
ToXContentFragment {
    public final long fiveMinutes;
    public final long fifteenMinutes;
    public final long twentyFourHours;
    public final long total;

    public TimeSeries(long total) {
        this.fiveMinutes = 0L;
        this.fifteenMinutes = 0L;
        this.twentyFourHours = 0L;
        this.total = total;
    }

    public TimeSeries(long fiveMinutes, long fifteenMinutes, long twentyFourHours, long total) {
        this.fiveMinutes = fiveMinutes;
        this.fifteenMinutes = fifteenMinutes;
        this.twentyFourHours = twentyFourHours;
        this.total = total;
    }

    TimeSeries withTotal(long total) {
        return new TimeSeries(this.fiveMinutes, this.fifteenMinutes, this.twentyFourHours, total);
    }

    public static TimeSeries merge(TimeSeries first, TimeSeries second) {
        return new TimeSeries(first.fiveMinutes + second.fiveMinutes, first.fifteenMinutes + second.fifteenMinutes, first.twentyFourHours + second.twentyFourHours, first.total + second.total);
    }

    public TimeSeries(StreamInput in) throws IOException {
        this.fiveMinutes = in.readVLong();
        this.fifteenMinutes = in.readVLong();
        this.twentyFourHours = in.readVLong();
        this.total = in.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0) ? in.readVLong() : 0L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("5m", this.fiveMinutes);
        builder.field("15m", this.fifteenMinutes);
        builder.field("24h", this.twentyFourHours);
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fiveMinutes);
        out.writeVLong(this.fifteenMinutes);
        out.writeVLong(this.twentyFourHours);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            out.writeVLong(this.total);
        }
    }

    public boolean areTimingsEmpty() {
        return this.fiveMinutes == 0L && this.fifteenMinutes == 0L && this.twentyFourHours == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeries that = (TimeSeries)o;
        return this.fiveMinutes == that.fiveMinutes && this.fifteenMinutes == that.fifteenMinutes && this.twentyFourHours == that.twentyFourHours && this.total == that.total;
    }

    public int hashCode() {
        return Objects.hash(this.fiveMinutes, this.fifteenMinutes, this.twentyFourHours, this.total);
    }

    public String toString() {
        return "TimeSeries{fiveMinutes=" + this.fiveMinutes + ", fifteenMinutes=" + this.fifteenMinutes + ", twentyFourHours=" + this.twentyFourHours + ", total=" + this.total + "}";
    }
}

