/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.script.ScriptCacheStats;
import org.elasticsearch.script.ScriptContextStats;
import org.elasticsearch.script.TimeSeries;
import org.elasticsearch.xcontent.ToXContent;

public record ScriptStats(List<ScriptContextStats> contextStats, long compilations, long cacheEvictions, long compilationLimitTriggered, TimeSeries compilationsHistory, TimeSeries cacheEvictionsHistory) implements Writeable,
ChunkedToXContent
{
    public static final ScriptStats IDENTITY = new ScriptStats(0L, 0L, 0L, new TimeSeries(0L), new TimeSeries(0L));

    public ScriptStats(long compilations, long cacheEvictions, long compilationLimitTriggered, TimeSeries compilationsHistory, TimeSeries cacheEvictionsHistory) {
        this(List.of(), compilations, cacheEvictions, compilationLimitTriggered, Objects.requireNonNullElseGet(compilationsHistory, () -> new TimeSeries(compilations)), Objects.requireNonNullElseGet(cacheEvictionsHistory, () -> new TimeSeries(cacheEvictions)));
    }

    public static ScriptStats merge(ScriptStats first, ScriptStats second) {
        List<ScriptContextStats> mergedScriptContextStats = List.of();
        if (!first.contextStats.isEmpty() || !second.contextStats.isEmpty()) {
            HashMap mapToCollectMergedStats = new HashMap();
            first.contextStats.forEach(cs -> mapToCollectMergedStats.merge(cs.context(), cs, ScriptContextStats::merge));
            second.contextStats.forEach(cs -> mapToCollectMergedStats.merge(cs.context(), cs, ScriptContextStats::merge));
            mergedScriptContextStats = new ArrayList(mapToCollectMergedStats.values());
        }
        return new ScriptStats(mergedScriptContextStats, first.compilations + second.compilations, first.cacheEvictions + second.cacheEvictions, first.compilationLimitTriggered + second.compilationLimitTriggered, TimeSeries.merge(first.compilationsHistory, second.compilationsHistory), TimeSeries.merge(first.cacheEvictionsHistory, second.cacheEvictionsHistory));
    }

    public static ScriptStats read(List<ScriptContextStats> contextStats) {
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptContextStats stats : contextStats) {
            compilations += stats.getCompilations();
            cacheEvictions += stats.getCacheEvictions();
            compilationLimitTriggered += stats.getCompilationLimitTriggered();
        }
        return new ScriptStats(contextStats.stream().sorted(ScriptContextStats::compareTo).toList(), compilations, cacheEvictions, compilationLimitTriggered, new TimeSeries(compilations), new TimeSeries(cacheEvictions));
    }

    public static ScriptStats read(ScriptContextStats context) {
        return new ScriptStats(context.getCompilations(), context.getCacheEvictions(), context.getCompilationLimitTriggered(), context.getCompilationsHistory(), context.getCacheEvictionsHistory());
    }

    public static ScriptStats read(StreamInput in) throws IOException {
        long cacheEvictions;
        long compilations;
        TimeSeries cacheEvictionsHistory;
        TimeSeries compilationsHistory;
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            compilationsHistory = new TimeSeries(in);
            cacheEvictionsHistory = new TimeSeries(in);
            compilations = compilationsHistory.total;
            cacheEvictions = cacheEvictionsHistory.total;
        } else {
            compilations = in.readVLong();
            cacheEvictions = in.readVLong();
            compilationsHistory = new TimeSeries(compilations);
            cacheEvictionsHistory = new TimeSeries(cacheEvictions);
        }
        long compilationLimitTriggered = in.readVLong();
        List<ScriptContextStats> contextStats = in.readList(ScriptContextStats::read);
        return new ScriptStats(contextStats, compilations, cacheEvictions, compilationLimitTriggered, compilationsHistory, cacheEvictionsHistory);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            this.compilationsHistory.writeTo(out);
            this.cacheEvictionsHistory.writeTo(out);
        } else {
            out.writeVLong(this.compilations);
            out.writeVLong(this.cacheEvictions);
        }
        out.writeVLong(this.compilationLimitTriggered);
        out.writeList(this.contextStats);
    }

    public List<ScriptContextStats> getContextStats() {
        return this.contextStats;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public ScriptCacheStats toScriptCacheStats() {
        if (this.contextStats.isEmpty()) {
            return new ScriptCacheStats(this);
        }
        Map<String, ScriptStats> contexts = Maps.newMapWithExpectedSize(this.contextStats.size());
        for (ScriptContextStats contextStats : this.contextStats) {
            contexts.put(contextStats.getContext(), ScriptStats.read(contextStats));
        }
        return new ScriptCacheStats(contexts);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(ChunkedToXContentHelper.startObject("script"), ChunkedToXContentHelper.field("compilations", this.compilations), ChunkedToXContentHelper.field("cache_evictions", this.cacheEvictions), ChunkedToXContentHelper.field("compilation_limit_triggered", this.compilationLimitTriggered), Iterators.single((builder, params) -> {
            if (this.compilationsHistory != null && !this.compilationsHistory.areTimingsEmpty()) {
                builder.startObject("compilations_history");
                this.compilationsHistory.toXContent(builder, params);
                builder.endObject();
            }
            if (this.cacheEvictionsHistory != null && !this.cacheEvictionsHistory.areTimingsEmpty()) {
                builder.startObject("compilations_history");
                this.cacheEvictionsHistory.toXContent(builder, params);
                builder.endObject();
            }
            return builder;
        }), ChunkedToXContentHelper.array("contexts", this.contextStats.iterator()), ChunkedToXContentHelper.endObject());
    }

    static final class Fields {
        static final String SCRIPT_STATS = "script";
        static final String CONTEXTS = "contexts";
        static final String COMPILATIONS = "compilations";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";

        Fields() {
        }
    }
}

