/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.IntConsumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestChunkedToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestSearchAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestSearchAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in search requests is deprecated.";
    public static final String TOTAL_HITS_AS_INT_PARAM = "rest_total_hits_as_int";
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    public static final String INCLUDE_NAMED_QUERIES_SCORE_PARAM = "include_named_queries_score";
    public static final Set<String> RESPONSE_PARAMS = Set.of("typed_keys", "rest_total_hits_as_int", "include_named_queries_score");
    private final SearchUsageHolder searchUsageHolder;
    private static final String[] suggestQueryStringParams = new String[]{"suggest_text", "suggest_size", "suggest_mode"};

    public RestSearchAction(SearchUsageHolder searchUsageHolder) {
        this.searchUsageHolder = searchUsageHolder;
    }

    @Override
    public String getName() {
        return "search_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_search"), new RestHandler.Route(RestRequest.Method.POST, "/_search"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search"), RestHandler.Route.builder(RestRequest.Method.GET, "/{index}/{type}/_search").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/{type}/_search").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build());
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = request.hasParam("min_compatible_shard_node") ? new SearchRequest(Version.fromString(request.param("min_compatible_shard_node"))) : new SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> RestSearchAction.parseSearchRequest(searchRequest, request, parser, client.getNamedWriteableRegistry(), setSize, this.searchUsageHolder)));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute(SearchAction.INSTANCE, searchRequest, new RestChunkedToXContentListener((RestChannel)channel));
        };
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, XContentParser requestContentParser, NamedWriteableRegistry namedWriteableRegistry, IntConsumer setSize) throws IOException {
        RestSearchAction.parseSearchRequest(searchRequest, request, requestContentParser, namedWriteableRegistry, setSize, null);
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, @Nullable XContentParser requestContentParser, NamedWriteableRegistry namedWriteableRegistry, IntConsumer setSize, @Nullable SearchUsageHolder searchUsageHolder) throws IOException {
        if (request.getRestApiVersion() == RestApiVersion.V_7 && request.hasParam("type")) {
            request.param("type");
            deprecationLogger.compatibleCritical("search_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        searchRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        if (requestContentParser != null) {
            if (searchUsageHolder == null) {
                searchRequest.source().parseXContent(requestContentParser, true);
            } else {
                searchRequest.source().parseXContent(requestContentParser, true, searchUsageHolder);
            }
        }
        int batchedReduceSize = request.paramAsInt("batched_reduce_size", searchRequest.getBatchedReduceSize());
        searchRequest.setBatchedReduceSize(batchedReduceSize);
        if (request.hasParam("pre_filter_shard_size")) {
            searchRequest.setPreFilterShardSize(request.paramAsInt("pre_filter_shard_size", 128));
        }
        if (request.hasParam("enable_fields_emulation")) {
            request.paramAsBoolean("enable_fields_emulation", false);
        }
        if (request.hasParam("max_concurrent_shard_requests")) {
            int maxConcurrentShardRequests = request.paramAsInt("max_concurrent_shard_requests", searchRequest.getMaxConcurrentShardRequests());
            searchRequest.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        if (request.hasParam("allow_partial_search_results")) {
            searchRequest.allowPartialSearchResults(request.paramAsBoolean("allow_partial_search_results", null));
        }
        searchRequest.searchType(request.param("search_type"));
        RestSearchAction.parseSearchSource(searchRequest.source(), request, setSize);
        searchRequest.requestCache(request.paramAsBoolean("request_cache", searchRequest.requestCache()));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
        RestSearchAction.validateSearchRequest(request, searchRequest);
        if (searchRequest.pointInTimeBuilder() != null) {
            RestSearchAction.preparePointInTime(searchRequest, request, namedWriteableRegistry);
        } else {
            searchRequest.setCcsMinimizeRoundtrips(request.paramAsBoolean("ccs_minimize_roundtrips", searchRequest.isCcsMinimizeRoundtrips()));
        }
        if (request.paramAsBoolean("force_synthetic_source", false)) {
            searchRequest.setForceSyntheticSource(true);
        }
    }

    private static void parseSearchSource(SearchSourceBuilder searchSourceBuilder, RestRequest request, IntConsumer setSize) {
        SuggestBuilder suggestBuilder;
        String sStats;
        String sSorts;
        FetchSourceContext fetchSourceContext;
        String sDocValueFields;
        StoredFieldsContext storedFieldsContext;
        QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        if (request.hasParam("from")) {
            searchSourceBuilder.from(request.paramAsInt("from", 0));
        }
        if (request.hasParam("size")) {
            int size = request.paramAsInt("size", 10);
            if (request.getRestApiVersion() == RestApiVersion.V_7 && size == -1) {
                deprecationLogger.compatibleCritical("search-api-size-1", "Using search size of -1 is deprecated and will be removed in future versions. Instead, don't use the `size` parameter if you don't want to set it explicitly.", new Object[0]);
            } else {
                setSize.accept(size);
            }
        }
        if (request.hasParam("explain")) {
            searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        }
        if (request.hasParam("version")) {
            searchSourceBuilder.version(request.paramAsBoolean("version", null));
        }
        if (request.hasParam("seq_no_primary_term")) {
            searchSourceBuilder.seqNoAndPrimaryTerm(request.paramAsBoolean("seq_no_primary_term", null));
        }
        if (request.hasParam("timeout")) {
            searchSourceBuilder.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasParam("terminate_after")) {
            int terminateAfter = request.paramAsInt("terminate_after", 0);
            searchSourceBuilder.terminateAfter(terminateAfter);
        }
        if ((storedFieldsContext = StoredFieldsContext.fromRestRequest(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), request)) != null) {
            searchSourceBuilder.storedFields(storedFieldsContext);
        }
        if ((sDocValueFields = request.param("docvalue_fields")) != null && Strings.hasText(sDocValueFields)) {
            String[] sFields;
            for (String field : sFields = Strings.splitStringByCommaToArray(sDocValueFields)) {
                searchSourceBuilder.docValueField(field, null);
            }
        }
        if ((fetchSourceContext = FetchSourceContext.parseFromRestRequest(request)) != null) {
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasParam("track_scores")) {
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if (request.hasParam("track_total_hits")) {
            if (Booleans.isBoolean((String)request.param("track_total_hits"))) {
                searchSourceBuilder.trackTotalHits(request.paramAsBoolean("track_total_hits", true));
            } else {
                searchSourceBuilder.trackTotalHitsUpTo(request.paramAsInt("track_total_hits", 10000));
            }
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            for (String sort : sorts = Strings.splitStringByCommaToArray(sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sStats = request.param("stats")) != null) {
            searchSourceBuilder.stats(Arrays.asList(Strings.splitStringByCommaToArray(sStats)));
        }
        if ((suggestBuilder = RestSearchAction.parseSuggestUrlParameters(request)) != null) {
            searchSourceBuilder.suggest(suggestBuilder);
        }
    }

    static SuggestBuilder parseSuggestUrlParameters(RestRequest request) {
        String suggestField = request.param("suggest_field");
        if (suggestField != null) {
            String suggestText = request.param("suggest_text", request.param("q"));
            int suggestSize = request.paramAsInt("suggest_size", 5);
            String suggestMode = request.param("suggest_mode");
            return new SuggestBuilder().addSuggestion(suggestField, ((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(suggestField).text(suggestText)).size(suggestSize)).suggestMode(TermSuggestionBuilder.SuggestMode.resolve(suggestMode)));
        }
        List<String> unconsumedParams = Arrays.stream(suggestQueryStringParams).filter(key -> request.param((String)key) != null).toList();
        if (!unconsumedParams.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains parameters %s but missing 'suggest_field' parameter.", request.path(), unconsumedParams.toString()));
        }
        return null;
    }

    static void preparePointInTime(SearchRequest request, RestRequest restRequest, NamedWriteableRegistry namedWriteableRegistry) {
        assert (request.pointInTimeBuilder() != null);
        ActionRequestValidationException validationException = null;
        if (request.indices().length > 0) {
            validationException = ValidateActions.addValidationError("[indices] cannot be used with point in time. Do not specify any index with point in time.", validationException);
        }
        if (!request.indicesOptions().equals(SearchRequest.DEFAULT_INDICES_OPTIONS)) {
            validationException = ValidateActions.addValidationError("[indicesOptions] cannot be used with point in time", validationException);
        }
        if (request.routing() != null) {
            validationException = ValidateActions.addValidationError("[routing] cannot be used with point in time", validationException);
        }
        if (request.preference() != null) {
            validationException = ValidateActions.addValidationError("[preference] cannot be used with point in time", validationException);
        }
        if (restRequest.paramAsBoolean("ccs_minimize_roundtrips", false)) {
            validationException = ValidateActions.addValidationError("[ccs_minimize_roundtrips] cannot be used with point in time", validationException);
            request.setCcsMinimizeRoundtrips(false);
        }
        ExceptionsHelper.reThrowIfNotNull(validationException);
        IndicesOptions indicesOptions = request.indicesOptions();
        IndicesOptions stricterIndicesOptions = IndicesOptions.fromOptions(indicesOptions.ignoreUnavailable(), indicesOptions.allowNoIndices(), false, false, false, true, true, indicesOptions.ignoreThrottled());
        request.indicesOptions(stricterIndicesOptions);
        SearchContextId searchContextId = request.pointInTimeBuilder().getSearchContextId(namedWriteableRegistry);
        request.indices(searchContextId.getActualIndices());
    }

    public static void validateSearchRequest(RestRequest restRequest, SearchRequest searchRequest) {
        RestSearchAction.checkRestTotalHits(restRequest, searchRequest);
        RestSearchAction.checkSearchType(restRequest, searchRequest);
        restRequest.paramAsBoolean(INCLUDE_NAMED_QUERIES_SCORE_PARAM, false);
    }

    private static void checkRestTotalHits(RestRequest restRequest, SearchRequest searchRequest) {
        Integer trackTotalHitsUpTo;
        boolean totalHitsAsInt = restRequest.paramAsBoolean(TOTAL_HITS_AS_INT_PARAM, false);
        if (!totalHitsAsInt) {
            return;
        }
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) == null) {
            searchRequest.source().trackTotalHits(true);
        } else if (trackTotalHitsUpTo != Integer.MAX_VALUE && trackTotalHitsUpTo != -1) {
            throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + trackTotalHitsUpTo);
        }
    }

    private static void checkSearchType(RestRequest restRequest, SearchRequest searchRequest) {
        if (restRequest.hasParam("search_type") && searchRequest.hasKnnSearch()) {
            throw new IllegalArgumentException("cannot set [search_type] when using [knn] search, since the search type is determined automatically");
        }
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }
}

