/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.CRC32;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.gateway.CorruptStateException;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class ChecksumBlobStoreFormat<T> {
    public static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("context_mode", Metadata.CONTEXT_MODE_SNAPSHOT));
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final String codec;
    private final String blobNameFormat;
    private final CheckedBiFunction<String, XContentParser, T, IOException> reader;
    private final CheckedBiFunction<String, XContentParser, T, IOException> fallbackReader;
    private final Function<T, ? extends ToXContent> writer;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedBiFunction<String, XContentParser, T, IOException> reader, @Nullable CheckedBiFunction<String, XContentParser, T, IOException> fallbackReader, Function<T, ? extends ToXContent> writer) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.codec = codec;
        this.fallbackReader = fallbackReader;
        this.writer = writer;
    }

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedBiFunction<String, XContentParser, T, IOException> reader, Function<T, ? extends ToXContent> writer) {
        this(codec, blobNameFormat, reader, null, writer);
    }

    public T read(String repoName, BlobContainer blobContainer, String name, NamedXContentRegistry namedXContentRegistry) throws IOException {
        String blobName = this.blobName(name);
        try (InputStream in = blobContainer.readBlob(blobName);){
            T t = this.deserialize(repoName, namedXContentRegistry, in);
            return t;
        }
    }

    public String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    public T deserialize(String repoName, NamedXContentRegistry namedXContentRegistry, InputStream input) throws IOException {
        DeserializeMetaBlobInputStream deserializeMetaBlobInputStream = new DeserializeMetaBlobInputStream(input);
        try {
            T result;
            block27: {
                CodecUtil.checkHeader((DataInput)new InputStreamDataInput((InputStream)deserializeMetaBlobInputStream), (String)this.codec, (int)1, (int)1);
                InputStream wrappedStream = deserializeMetaBlobInputStream.nextBytesCompressed() ? CompressorFactory.COMPRESSOR.threadLocalInputStream(deserializeMetaBlobInputStream) : deserializeMetaBlobInputStream;
                if (this.fallbackReader != null) {
                    BytesReference bytesReference = Streams.readFully(wrappedStream);
                    deserializeMetaBlobInputStream.verifyFooter();
                    try (XContentParser parser = XContentType.SMILE.xContent().createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)bytesReference.streamInput());){
                        result = this.reader.apply(repoName, parser);
                        XContentParserUtils.ensureExpectedToken(null, parser.nextToken(), parser);
                        break block27;
                    }
                    catch (Exception e) {
                        try (XContentParser parser2 = XContentType.SMILE.xContent().createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)bytesReference.streamInput());){
                            result = this.fallbackReader.apply(repoName, parser2);
                            XContentParserUtils.ensureExpectedToken(null, parser2.nextToken(), parser2);
                            break block27;
                        }
                    }
                }
                try (XContentParser parser = XContentType.SMILE.xContent().createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, wrappedStream);){
                    result = this.reader.apply(repoName, parser);
                    XContentParserUtils.ensureExpectedToken(null, parser.nextToken(), parser);
                }
                deserializeMetaBlobInputStream.verifyFooter();
            }
            return result;
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
        catch (Exception e) {
            try {
                Streams.consumeFully(deserializeMetaBlobInputStream);
                deserializeMetaBlobInputStream.verifyFooter();
            }
            catch (CorruptStateException cse) {
                cse.addSuppressed(e);
                throw cse;
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name, boolean compress) throws IOException {
        this.write(obj, blobContainer, name, compress, Collections.emptyMap());
    }

    public void write(T obj, BlobContainer blobContainer, String name, boolean compress, Map<String, String> serializationParams) throws IOException {
        String blobName = this.blobName(name);
        blobContainer.writeMetadataBlob(blobName, false, false, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> this.serialize(obj, blobName, compress, serializationParams, (OutputStream)out)));
    }

    public void serialize(T obj, String blobName, boolean compress, OutputStream outputStream) throws IOException {
        this.serialize(obj, blobName, compress, Collections.emptyMap(), outputStream);
    }

    public void serialize(T obj, String blobName, boolean compress, Map<String, String> extraParams, OutputStream outputStream) throws IOException {
        try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.serialize(blob=\"" + blobName + "\")", blobName, org.elasticsearch.core.Streams.noCloseStream((OutputStream)outputStream), 4096);){
            CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)1);
            try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream((IndexOutput)indexOutput){

                @Override
                public void close() {
                }
            };
                 XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.SMILE, (OutputStream)(compress ? CompressorFactory.COMPRESSOR.threadLocalOutputStream(indexOutputOutputStream) : indexOutputOutputStream));){
                ToXContent.Params params = extraParams.isEmpty() ? SNAPSHOT_ONLY_FORMAT_PARAMS : new ToXContent.DelegatingMapParams(extraParams, SNAPSHOT_ONLY_FORMAT_PARAMS);
                builder.startObject();
                this.writer.apply(obj).toXContent(builder, params);
                builder.endObject();
            }
            CodecUtil.writeFooter((IndexOutput)indexOutput);
        }
    }

    private static final class DeserializeMetaBlobInputStream
    extends FilterInputStream {
        private final CRC32 crc32 = new CRC32();
        private final byte[] buffer = new byte[8192];
        private int bufferCount;
        private int bufferPos;

        DeserializeMetaBlobInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            if (this.getAvailable() <= 0) {
                return -1;
            }
            return this.buffer[this.bufferPos++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remaining;
            int r;
            int read = 0;
            for (remaining = len; remaining > 0 && (r = this.doRead(b, off + read, remaining)) > 0; remaining -= r) {
                read += r;
            }
            if (len > 0 && remaining == len) {
                return -1;
            }
            return read;
        }

        @Override
        public void close() throws IOException {
        }

        private int doRead(byte[] b, int off, int len) throws IOException {
            int available = this.getAvailable();
            if (available < 0) {
                return -1;
            }
            int read = Math.min(available, len);
            System.arraycopy(this.buffer, this.bufferPos, b, off, read);
            this.bufferPos += read;
            return read;
        }

        void verifyFooter() throws CorruptStateException {
            long checksumInFooter;
            if (this.bufferCount - this.bufferPos != CodecUtil.footerLength()) {
                throw new CorruptStateException("should have consumed all but 16 bytes from the buffer but saw buffer pos [" + this.bufferPos + "] and count [" + this.bufferCount + "]");
            }
            this.crc32.update(this.buffer, 0, this.bufferPos + 8);
            int magicFound = Numbers.bytesToInt(this.buffer, this.bufferPos);
            if (magicFound != -1071082520) {
                throw new CorruptStateException("unexpected footer magic [" + magicFound + "]");
            }
            int algorithmFound = Numbers.bytesToInt(this.buffer, this.bufferPos + 4);
            if (algorithmFound != 0) {
                throw new CorruptStateException("unexpected algorithm [" + algorithmFound + "]");
            }
            long checksum = this.crc32.getValue();
            if (checksum != (checksumInFooter = Numbers.bytesToLong(this.buffer, this.bufferPos + 8))) {
                throw new CorruptStateException("checksums do not match read [" + checksum + "] but expected [" + checksumInFooter + "]");
            }
        }

        boolean nextBytesCompressed() {
            assert (this.bufferPos > 0) : "buffer position must be greater than 0 but was [" + this.bufferPos + "]";
            return CompressorFactory.COMPRESSOR.isCompressed(new BytesArray(this.buffer, this.bufferPos, this.bufferCount - this.bufferPos));
        }

        private int getAvailable() throws IOException {
            int footerLen = CodecUtil.footerLength();
            if (this.bufferCount == 0) {
                this.bufferCount = org.elasticsearch.core.Streams.readFully((InputStream)this.in, (byte[])this.buffer, (int)0, (int)this.buffer.length);
            } else if (this.bufferPos == this.bufferCount - footerLen) {
                assert (this.bufferCount >= footerLen);
                this.crc32.update(this.buffer, 0, this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, footerLen);
                this.bufferCount = footerLen + org.elasticsearch.core.Streams.readFully((InputStream)this.in, (byte[])this.buffer, (int)footerLen, (int)(this.buffer.length - footerLen));
                this.bufferPos = 0;
            }
            return this.bufferCount - this.bufferPos - footerLen;
        }
    }
}

