/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.LeaderHeartbeatService;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public interface ClusterCoordinationPlugin {
    default public BiConsumer<DiscoveryNode, ClusterState> getJoinValidator() {
        return null;
    }

    default public Map<String, ElectionStrategy> getElectionStrategies() {
        return Collections.emptyMap();
    }

    default public Optional<PersistedStateFactory> getPersistedStateFactory() {
        return Optional.empty();
    }

    default public Optional<PersistedClusterStateServiceFactory> getPersistedClusterStateServiceFactory() {
        return Optional.empty();
    }

    default public Optional<ReconfiguratorFactory> getReconfiguratorFactory() {
        return Optional.empty();
    }

    default public Optional<PreVoteCollector.Factory> getPreVoteCollectorFactory() {
        return Optional.empty();
    }

    default public Optional<LeaderHeartbeatService> getLeaderHeartbeatService(Settings settings) {
        return Optional.empty();
    }

    public static interface ReconfiguratorFactory {
        public Reconfigurator newReconfigurator(Settings var1, ClusterSettings var2);
    }

    public static interface PersistedClusterStateServiceFactory {
        public PersistedClusterStateService newPersistedClusterStateService(NodeEnvironment var1, NamedXContentRegistry var2, ClusterSettings var3, ThreadPool var4);
    }

    public static interface PersistedStateFactory {
        public CoordinationState.PersistedState createPersistedState(Settings var1, TransportService var2, PersistedClusterStateService var3) throws IOException;
    }
}

