/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.internal;

import java.util.List;
import java.util.ServiceLoader;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.index.IndexVersion;

public interface VersionExtension {
    public TransportVersion getCurrentTransportVersion();

    public IndexVersion getCurrentIndexVersion();

    public static VersionExtension load() {
        ServiceLoader<VersionExtension> loader = ServiceLoader.load(VersionExtension.class);
        List<ServiceLoader.Provider<VersionExtension>> extensions = loader.stream().toList();
        if (extensions.size() > 1) {
            throw new IllegalStateException("More than one version extension found");
        }
        if (extensions.size() == 0) {
            return null;
        }
        return extensions.get(0).get();
    }
}

