/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Collections;
import java.util.function.LongSupplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class CoordinatorRewriteContext
extends QueryRewriteContext {
    private final IndexLongFieldRange indexLongFieldRange;
    private final DateFieldMapper.DateFieldType timestampFieldType;

    public CoordinatorRewriteContext(XContentParserConfiguration parserConfig, Client client, LongSupplier nowInMillis, IndexLongFieldRange indexLongFieldRange, DateFieldMapper.DateFieldType timestampFieldType) {
        super(parserConfig, client, nowInMillis, null, MappingLookup.EMPTY, Collections.emptyMap(), null, null, null, null, null, null, null, null);
        this.indexLongFieldRange = indexLongFieldRange;
        this.timestampFieldType = timestampFieldType;
    }

    long getMinTimestamp() {
        return this.indexLongFieldRange.getMin();
    }

    long getMaxTimestamp() {
        return this.indexLongFieldRange.getMax();
    }

    boolean hasTimestampData() {
        return this.indexLongFieldRange.isComplete() && this.indexLongFieldRange != IndexLongFieldRange.EMPTY;
    }

    @Override
    @Nullable
    public MappedFieldType getFieldType(String fieldName) {
        if (!fieldName.equals(this.timestampFieldType.name())) {
            return null;
        }
        return this.timestampFieldType;
    }

    @Override
    public CoordinatorRewriteContext convertToCoordinatorRewriteContext() {
        return this;
    }
}

