/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> RoutingFieldMapper.get(false), c -> new Builder());
    public static final MappedFieldType FIELD_TYPE = new RoutingFieldType();
    private final boolean required;
    private static final RoutingFieldMapper REQUIRED = new RoutingFieldMapper(true);
    private static final RoutingFieldMapper NOT_REQUIRED = new RoutingFieldMapper(false);
    private static final Map<String, NamedAnalyzer> ANALYZERS = Map.of("_routing", Lucene.KEYWORD_ANALYZER);

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private static RoutingFieldMapper toType(FieldMapper in) {
        return (RoutingFieldMapper)in;
    }

    public static RoutingFieldMapper get(boolean required) {
        return required ? REQUIRED : NOT_REQUIRED;
    }

    private RoutingFieldMapper(boolean required) {
        super(FIELD_TYPE);
        this.required = required;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return ANALYZERS;
    }

    public boolean required() {
        return this.required;
    }

    @Override
    public void preParse(DocumentParserContext context) {
        String routing = context.sourceToParse().routing();
        if (routing != null) {
            context.doc().add((IndexableField)new StringField(this.fieldType().name(), routing, Field.Store.YES));
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> required = FieldMapper.Parameter.boolParam("required", false, m -> RoutingFieldMapper.toType((FieldMapper)m).required, false);

        protected Builder() {
            super("_routing");
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.required};
        }

        @Override
        public RoutingFieldMapper build() {
            return RoutingFieldMapper.get(this.required.getValue());
        }
    }

    public static class Defaults {
        public static final boolean REQUIRED = false;
    }

    static final class RoutingFieldType
    extends StringFieldType {
        private RoutingFieldType() {
            super("_routing", true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_routing";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), "_routing");
        }
    }
}

