/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class FieldNamesFieldMapper
extends MetadataFieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FieldNamesFieldMapper.class);
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";
    public static final String ENABLED_DEPRECATION_MESSAGE = "Disabling _field_names is not necessary because it no longer carries a large index overhead. Support for the `enabled` setting will be removed in a future major version. Please remove it from your mappings and templates.";
    private static final FieldNamesFieldMapper DEFAULT = new FieldNamesFieldMapper(Defaults.ENABLED, true);
    private static final FieldNamesFieldMapper DEFAULT_OLD = new FieldNamesFieldMapper(Defaults.ENABLED, false);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> c.indexVersionCreated().onOrAfter(IndexVersion.V_8_0_0) ? DEFAULT : DEFAULT_OLD, c -> new Builder(c.indexVersionCreated()));
    private final Explicit<Boolean> enabled;
    private final boolean createdOnOrAfterV8;

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.createdOnOrAfterV8).init(this);
    }

    private static FieldNamesFieldMapper toType(FieldMapper in) {
        return (FieldNamesFieldMapper)in;
    }

    private FieldNamesFieldMapper(Explicit<Boolean> enabled, boolean createdOnOrAfterV8) {
        super(FieldNamesFieldType.get(enabled.value()));
        this.enabled = enabled;
        this.createdOnOrAfterV8 = createdOnOrAfterV8;
    }

    @Override
    public FieldNamesFieldType fieldType() {
        return (FieldNamesFieldType)super.fieldType();
    }

    public void addFieldNames(DocumentParserContext context, String field) {
        if (!this.enabled.value().booleanValue()) {
            return;
        }
        assert (FieldNamesFieldMapper.noDocValues(field, context)) : "Field " + field + " should not have docvalues";
        context.doc().add((IndexableField)new StringField("_field_names", field, Field.Store.NO));
    }

    private static boolean noDocValues(String field, DocumentParserContext context) {
        MappedFieldType ft = context.mappingLookup().getFieldType(field);
        return ft == null || !ft.hasDocValues();
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam("enabled", m -> FieldNamesFieldMapper.toType((FieldMapper)m).enabled, Defaults.ENABLED.value());
        private final boolean createdOnOrAfterV8;

        Builder(IndexVersion indexVersionCreated) {
            this(indexVersionCreated.onOrAfter(IndexVersion.V_8_0_0));
        }

        Builder(boolean createdOnOrAfterV8) {
            super("_field_names");
            this.createdOnOrAfterV8 = createdOnOrAfterV8;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.enabled};
        }

        @Override
        public FieldNamesFieldMapper build() {
            if (this.enabled.getValue().explicit()) {
                if (this.createdOnOrAfterV8) {
                    throw new MapperParsingException("The `enabled` setting for the `_field_names` field has been deprecated and removed. Please remove it from your mappings and templates.");
                }
                deprecationLogger.warn(DeprecationCategory.TEMPLATES, "field_names_enabled_parameter", FieldNamesFieldMapper.ENABLED_DEPRECATION_MESSAGE, new Object[0]);
            }
            if (Defaults.ENABLED.equals(this.enabled.getValue())) {
                return this.createdOnOrAfterV8 ? DEFAULT : DEFAULT_OLD;
            }
            return new FieldNamesFieldMapper(this.enabled.getValue(), this.createdOnOrAfterV8);
        }
    }

    public static final class FieldNamesFieldType
    extends TermBasedFieldType {
        private static final FieldNamesFieldType ENABLED = new FieldNamesFieldType(true);
        private static final FieldNamesFieldType DISABLED = new FieldNamesFieldType(false);
        private final boolean enabled;

        public static FieldNamesFieldType get(boolean enabled) {
            return enabled ? ENABLED : DISABLED;
        }

        private FieldNamesFieldType(boolean enabled) {
            super("_field_names", true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.enabled = enabled;
        }

        @Override
        public String typeName() {
            return "_field_names";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on _field_names");
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            if (!this.isEnabled()) {
                throw new IllegalStateException("Cannot run [exists] queries if the [_field_names] field is disabled");
            }
            deprecationLogger.warn(DeprecationCategory.MAPPINGS, "terms_query_on_field_names", "terms query on the _field_names field is deprecated and will be removed, use exists query instead", new Object[0]);
            return super.termQuery(value, context);
        }
    }

    public static class Defaults {
        public static final String NAME = "_field_names";
        public static final Explicit<Boolean> ENABLED = Explicit.IMPLICIT_TRUE;
    }
}

