/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public final class CustomTermFreqField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private final int fieldValue;

    public CustomTermFreqField(String fieldName, CharSequence term, int fieldValue) {
        super(fieldName, term, (IndexableFieldType)FIELD_TYPE);
        this.fieldValue = fieldValue;
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        CustomTermFreqTokenStream stream = reuse instanceof CustomTermFreqTokenStream ? (CustomTermFreqTokenStream)reuse : new CustomTermFreqTokenStream();
        stream.setValues((String)this.fieldsData, this.fieldValue);
        return stream;
    }

    static {
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
    }

    private static final class CustomTermFreqTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final TermFrequencyAttribute freqAttribute = (TermFrequencyAttribute)this.addAttribute(TermFrequencyAttribute.class);
        private boolean used = true;
        private String value = null;
        private int freq = 0;

        private CustomTermFreqTokenStream() {
        }

        void setValues(String value, int freq) {
            this.value = value;
            this.freq = freq;
        }

        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.freqAttribute.setTermFrequency(this.freq);
            this.used = true;
            return true;
        }

        public void reset() {
            this.used = false;
        }

        public void close() {
            this.value = null;
        }
    }
}

