/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.codec.tsdb.ForUtil;

public class DocValuesForUtil {
    private static final int BITS_IN_FOUR_BYTES = 32;
    private static final int BITS_IN_FIVE_BYTES = 40;
    private static final int BITS_IN_SIX_BYTES = 48;
    private static final int BITS_IN_SEVEN_BYTES = 56;
    private final ForUtil forUtil = new ForUtil();
    private final int blockSize;
    private final byte[] encoded;

    public DocValuesForUtil() {
        this(128);
    }

    private DocValuesForUtil(int blockSize) {
        this.blockSize = blockSize;
        this.encoded = new byte[1024];
    }

    public static int roundBits(int bitsPerValue) {
        if (bitsPerValue > 24 && bitsPerValue <= 32) {
            return 32;
        }
        if (bitsPerValue > 32 && bitsPerValue <= 40) {
            return 40;
        }
        if (bitsPerValue > 40 && bitsPerValue <= 48) {
            return 48;
        }
        if (bitsPerValue > 48 && bitsPerValue <= 56) {
            return 56;
        }
        if (bitsPerValue > 56) {
            return 64;
        }
        return bitsPerValue;
    }

    public void encode(long[] in, int bitsPerValue, DataOutput out) throws IOException {
        if (bitsPerValue <= 24) {
            this.forUtil.encode(in, bitsPerValue, out);
        } else if (bitsPerValue <= 32) {
            DocValuesForUtil.collapse32(in);
            for (int i = 0; i < this.blockSize / 2; ++i) {
                out.writeLong(in[i]);
            }
        } else if (bitsPerValue == 40 || bitsPerValue == 48 || bitsPerValue == 56) {
            this.encodeFiveSixOrSevenBytesPerValue(in, bitsPerValue, out);
        } else {
            assert (bitsPerValue > 56) : "bitsPerValue must be greater than 56 but was [" + bitsPerValue + "]";
            for (long l : in) {
                out.writeLong(l);
            }
        }
    }

    private void encodeFiveSixOrSevenBytesPerValue(long[] in, int bitsPerValue, DataOutput out) throws IOException {
        int bytesPerValue = bitsPerValue / 8;
        for (int i = 0; i < in.length; ++i) {
            ByteUtils.writeLongLE(in[i], this.encoded, i * bytesPerValue);
        }
        out.writeBytes(this.encoded, bytesPerValue * in.length);
    }

    public void decode(int bitsPerValue, DataInput in, long[] out) throws IOException {
        if (bitsPerValue <= 24) {
            this.forUtil.decode(bitsPerValue, in, out);
        } else if (bitsPerValue <= 32) {
            in.readLongs(out, 0, this.blockSize / 2);
            DocValuesForUtil.expand32(out);
        } else if (bitsPerValue == 40 || bitsPerValue == 48 || bitsPerValue == 56) {
            this.decodeFiveSixOrSevenBytesPerValue(bitsPerValue, in, out);
        } else {
            assert (bitsPerValue > 56) : "bitsPerValue must be greater than 56 but was [" + bitsPerValue + "]";
            in.readLongs(out, 0, this.blockSize);
        }
    }

    private void decodeFiveSixOrSevenBytesPerValue(int bitsPerValue, DataInput in, long[] out) throws IOException {
        int bytesPerValue = bitsPerValue / 8;
        long mask = (1L << bitsPerValue) - 1L;
        byte[] buffer = new byte[bytesPerValue * this.blockSize + 8 - bytesPerValue];
        in.readBytes(buffer, 0, bytesPerValue * this.blockSize);
        for (int i = 0; i < this.blockSize; ++i) {
            out[i] = ByteUtils.readLongLE(buffer, i * bytesPerValue) & mask;
        }
    }

    private static void collapse32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            arr[i] = arr[i] << 32 | arr[64 + i];
        }
    }

    private static void expand32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            long l = arr[i];
            arr[i] = l >>> 32;
            arr[64 + i] = l & 0xFFFFFFFFL;
        }
    }
}

