/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpInfo
implements ReportingService.Info {
    private final BoundTransportAddress address;
    private final long maxContentLength;

    public HttpInfo(StreamInput in) throws IOException {
        this(new BoundTransportAddress(in), in.readLong());
    }

    public HttpInfo(BoundTransportAddress address, long maxContentLength) {
        this.address = address;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        out.writeLong(this.maxContentLength);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.array("bound_address", (Object[])this.address.boundAddresses());
        TransportAddress publishAddress = this.address.publishAddress();
        Object publishAddressString = publishAddress.toString();
        String hostString = publishAddress.address().getHostString();
        if (!InetAddresses.isInetAddress(hostString)) {
            publishAddressString = hostString + "/" + publishAddress;
        }
        builder.field("publish_address", (String)publishAddressString);
        builder.humanReadableField("max_content_length_in_bytes", "max_content_length", (Object)ByteSizeValue.ofBytes(this.maxContentLength));
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String MAX_CONTENT_LENGTH = "max_content_length";
        static final String MAX_CONTENT_LENGTH_IN_BYTES = "max_content_length_in_bytes";

        Fields() {
        }
    }
}

