/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.stats;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.health.stats.HealthApiStats;
import org.elasticsearch.health.stats.HealthApiStatsAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class HealthApiStatsTransportAction
extends TransportNodesAction<HealthApiStatsAction.Request, HealthApiStatsAction.Response, HealthApiStatsAction.Request.Node, HealthApiStatsAction.Response.Node> {
    private final HealthApiStats healthApiStats;

    @Inject
    public HealthApiStatsTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, HealthApiStats healthApiStats) {
        super("cluster:monitor/health_api/stats", threadPool, clusterService, transportService, actionFilters, HealthApiStatsAction.Request::new, HealthApiStatsAction.Request.Node::new, "management");
        this.healthApiStats = healthApiStats;
    }

    @Override
    protected HealthApiStatsAction.Response newResponse(HealthApiStatsAction.Request request, List<HealthApiStatsAction.Response.Node> nodes, List<FailedNodeException> failures) {
        return new HealthApiStatsAction.Response(this.clusterService.getClusterName(), nodes, failures);
    }

    @Override
    protected HealthApiStatsAction.Request.Node newNodeRequest(HealthApiStatsAction.Request request) {
        return new HealthApiStatsAction.Request.Node(request);
    }

    @Override
    protected HealthApiStatsAction.Response.Node newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new HealthApiStatsAction.Response.Node(in);
    }

    @Override
    protected HealthApiStatsAction.Response.Node nodeOperation(HealthApiStatsAction.Request.Node request, Task task) {
        HealthApiStatsAction.Response.Node statsResponse = new HealthApiStatsAction.Response.Node(this.clusterService.localNode());
        if (this.healthApiStats.hasCounters()) {
            statsResponse.setStats(this.healthApiStats.getStats());
        }
        return statsResponse;
    }
}

