/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.health.node.HealthInfoCache;
import org.elasticsearch.health.node.action.HealthNodeRequest;
import org.elasticsearch.health.node.action.TransportHealthNodeAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class FetchHealthInfoCacheAction
extends ActionType<Response> {
    public static final FetchHealthInfoCacheAction INSTANCE = new FetchHealthInfoCacheAction();
    public static final String NAME = "cluster:monitor/fetch/health/info";

    private FetchHealthInfoCacheAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportHealthNodeAction<Request, Response> {
        private final HealthInfoCache nodeHealthOverview;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, HealthInfoCache nodeHealthOverview) {
            super(FetchHealthInfoCacheAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, Response::new, "management");
            this.nodeHealthOverview = nodeHealthOverview;
        }

        @Override
        protected void healthOperation(Task task, Request request, ClusterState clusterState, ActionListener<Response> listener) {
            listener.onResponse(new Response(this.nodeHealthOverview.getHealthInfo()));
        }
    }

    public static class Response
    extends ActionResponse {
        private final HealthInfo healthInfo;

        public Response(HealthInfo healthInfo) {
            this.healthInfo = healthInfo;
        }

        public Response(StreamInput input) throws IOException {
            this.healthInfo = new HealthInfo(input);
        }

        @Override
        public void writeTo(StreamOutput output) throws IOException {
            this.healthInfo.writeTo(output);
        }

        public HealthInfo getHealthInfo() {
            return this.healthInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.healthInfo.equals(response.healthInfo);
        }

        public int hashCode() {
            return Objects.hash(this.healthInfo);
        }
    }

    public static class Request
    extends HealthNodeRequest {
        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public String getDescription() {
            return "Fetching health information from the health node.";
        }
    }
}

