/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.metadata;

import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.health.metadata.HealthMetadata;
import org.elasticsearch.health.node.selection.HealthNodeTaskExecutor;
import org.elasticsearch.indices.ShardLimitValidator;

public class HealthMetadataService {
    private static final Logger logger = LogManager.getLogger(HealthMetadataService.class);
    private final ClusterService clusterService;
    private final ClusterStateListener clusterStateListener;
    private final MasterServiceTaskQueue<UpsertHealthMetadataTask> taskQueue;
    private volatile boolean enabled;
    private volatile boolean isMaster = false;
    private volatile HealthMetadata localHealthMetadata;

    private HealthMetadataService(ClusterService clusterService, Settings settings) {
        this.clusterService = clusterService;
        this.clusterStateListener = this::updateOnClusterStateChange;
        this.enabled = HealthNodeTaskExecutor.ENABLED_SETTING.get(settings);
        this.localHealthMetadata = HealthMetadataService.initialHealthMetadata(settings);
        this.taskQueue = clusterService.createTaskQueue("health metadata service", Priority.NORMAL, new Executor());
    }

    public static HealthMetadataService create(ClusterService clusterService, Settings settings) {
        HealthMetadataService healthMetadataService = new HealthMetadataService(clusterService, settings);
        healthMetadataService.registerListeners();
        return healthMetadataService;
    }

    private void registerListeners() {
        if (this.enabled) {
            this.clusterService.addListener(this.clusterStateListener);
        }
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(HealthNodeTaskExecutor.ENABLED_SETTING, this::updateOnHealthNodeEnabledChange);
        Stream.of(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING).forEach(setting -> clusterSettings.addSettingsUpdateConsumer(setting, value -> this.updateOnDiskSettingsUpdated(setting.getKey(), value.getStringRep())));
        Stream.of(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING, DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING, DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING).forEach(setting -> clusterSettings.addSettingsUpdateConsumer(setting, value -> this.updateOnDiskSettingsUpdated(setting.getKey(), value.getStringRep())));
        Stream.of(ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE, ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE_FROZEN).forEach(setting -> clusterSettings.addSettingsUpdateConsumer(setting, value -> this.updateOnShardLimitsSettingsUpdated(setting.getKey(), (Integer)value)));
    }

    private void updateOnHealthNodeEnabledChange(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            this.clusterService.addListener(this.clusterStateListener);
            if (this.canPostClusterStateUpdates(this.clusterService.state())) {
                this.taskQueue.submitTask("health-node-enabled", new UpsertHealthMetadataTask(), null);
            }
        } else {
            this.clusterService.removeListener(this.clusterStateListener);
        }
    }

    private boolean canPostClusterStateUpdates(ClusterState state) {
        return this.isMaster && state.nodesIfRecovered().getMinNodeVersion().onOrAfter(Version.V_8_5_0);
    }

    private void updateOnClusterStateChange(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
        }
        if (this.canPostClusterStateUpdates(event.state()) && !this.localHealthMetadata.equals(HealthMetadata.getFromClusterState(event.state()))) {
            this.taskQueue.submitTask("store-local-health-metadata", new UpsertHealthMetadataTask(), null);
        }
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "health", HealthMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "health", HealthMetadata::readDiffFrom));
    }

    private void updateOnDiskSettingsUpdated(String settingName, String value) {
        HealthMetadata.Disk.Builder diskBuilder = HealthMetadata.Disk.newBuilder(this.localHealthMetadata.getDiskMetadata());
        HealthMetadata.Builder healthMetadataBuilder = HealthMetadata.newBuilder(this.localHealthMetadata);
        if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey().equals(settingName)) {
            diskBuilder.highWatermark(value, settingName);
        } else if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey().equals(settingName)) {
            diskBuilder.floodStageWatermark(value, settingName);
        } else if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.getKey().equals(settingName)) {
            diskBuilder.frozenFloodStageWatermark(value, settingName);
        } else if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.getKey().equals(settingName)) {
            diskBuilder.frozenFloodStageMaxHeadroom(value, settingName);
        } else if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.getKey().equals(settingName)) {
            diskBuilder.highMaxHeadroom(value, settingName);
        } else if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.getKey().equals(settingName)) {
            diskBuilder.floodStageMaxHeadroom(value, settingName);
        }
        this.localHealthMetadata = healthMetadataBuilder.disk(diskBuilder.build()).build();
    }

    private void updateOnShardLimitsSettingsUpdated(String settingName, Integer value) {
        HealthMetadata.ShardLimits.Builder shardLimitsBuilder = HealthMetadata.ShardLimits.newBuilder(this.localHealthMetadata.getShardLimitsMetadata());
        HealthMetadata.Builder healthMetadataBuilder = HealthMetadata.newBuilder(this.localHealthMetadata);
        if (ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE.getKey().equals(settingName)) {
            shardLimitsBuilder.maxShardsPerNode(value);
        } else if (ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE_FROZEN.getKey().equals(settingName)) {
            shardLimitsBuilder.maxShardsPerNodeFrozen(value);
        }
        this.localHealthMetadata = healthMetadataBuilder.shardLimits(shardLimitsBuilder.build()).build();
    }

    private static HealthMetadata initialHealthMetadata(Settings settings) {
        return new HealthMetadata(new HealthMetadata.Disk(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.get(settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.get(settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.get(settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.get(settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.get(settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.get(settings)), new HealthMetadata.ShardLimits(ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE.get(settings), ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE_FROZEN.get(settings)));
    }

    private class Executor
    extends SimpleBatchedExecutor<UpsertHealthMetadataTask, Void> {
        private Executor() {
        }

        @Override
        public Tuple<ClusterState, Void> executeTask(UpsertHealthMetadataTask task, ClusterState clusterState) {
            HealthMetadata finalHealthMetadata = HealthMetadataService.this.localHealthMetadata;
            HealthMetadata initialHealthMetadata = HealthMetadata.getFromClusterState(clusterState);
            return Tuple.tuple((Object)(finalHealthMetadata.equals(initialHealthMetadata) ? clusterState : clusterState.copyAndUpdate(b -> b.putCustom("health", finalHealthMetadata))), null);
        }

        @Override
        public void taskSucceeded(UpsertHealthMetadataTask task, Void unused) {
        }

        @Override
        public String describeTasks(List<UpsertHealthMetadataTask> tasks) {
            return "";
        }
    }

    private static class UpsertHealthMetadataTask
    implements ClusterStateTaskListener {
        private UpsertHealthMetadataTask() {
        }

        @Override
        public void onFailure(@Nullable Exception e) {
            logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.WARN, () -> "failure during health metadata update", (Throwable)e);
        }
    }
}

